/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.debug.VariableBreakpointMessage;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.wizards.AbstractBreakpointPage;
import com.ca.intertest.wizards.AbstractBreakpointWizard;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VariableBreakpointPage
extends AbstractBreakpointPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final String PAGE_NAME = Messages.VariableBreakpointPage_0;
    private Combo vbpDataname;
    private Text textVbpLength;
    private Text textVbpOffset;

    public VariableBreakpointPage(AbstractBreakpointWizard wizard) {
        super(wizard, PAGE_NAME, "com.ca.intertest.breakpoint.watch");
    }

    @Override
    public String getName() {
        return PAGE_NAME;
    }

    @Override
    protected void setOptions(Composite parent) {
        Group vbpGroup = new Group(parent, 0);
        vbpGroup.setLayout((Layout)new GridLayout(2, false));
        vbpGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        GridData gridData = new GridData(4, 4, false, false);
        gridData.verticalAlignment = 0x1000000;
        gridData.horizontalAlignment = 0x1000008;
        Label labelVbpArea = new Label((Composite)vbpGroup, 0);
        labelVbpArea.setLayoutData((Object)gridData);
        labelVbpArea.setText(Messages.VariableBreakpointPage_1);
        this.vbpDataname = new Combo((Composite)vbpGroup, 2816);
        this.vbpDataname.setLayoutData((Object)new GridData(4, 4, true, false));
        this.vbpDataname.setItems(this.getLeftItems());
        this.vbpDataname.select(this.matchItem(this.getLeftItems()));
        if (this.wizard.isCICS()) {
            Composite cicsGroup = new Composite((Composite)vbpGroup, 0);
            gridData = new GridData(4, 0, true, false, 2, 1);
            gridData.horizontalAlignment = 0x1000008;
            cicsGroup.setLayoutData((Object)gridData);
            cicsGroup.setLayout((Layout)new GridLayout(4, false));
            Label labelVbpLength = new Label(cicsGroup, 0);
            gridData = new GridData(4, 0, false, false);
            gridData.verticalAlignment = 0x1000000;
            gridData.horizontalAlignment = 0x1000008;
            labelVbpLength.setLayoutData((Object)gridData);
            labelVbpLength.setText(Messages.VariableBreakpointPage_2);
            gridData = new GridData(4, 0, false, false);
            gridData.horizontalAlignment = 0x1000008;
            this.textVbpLength = new Text(cicsGroup, 2048);
            this.textVbpLength.setLayoutData((Object)gridData);
            this.textVbpLength.setTextLimit(10);
            this.textVbpLength.setText("");
            this.textVbpLength.addVerifyListener((VerifyListener)new verifyDigit(false));
            TextUtil.setWidth(this.textVbpLength, 4, 4);
            Label labelVbpOffset = new Label(cicsGroup, 0);
            labelVbpOffset.setLayoutData((Object)new GridData(4, 0, false, false));
            labelVbpOffset.setText(Messages.VariableBreakpointPage_4);
            gridData = new GridData(4, 0, false, false);
            gridData.horizontalAlignment = 0x1000008;
            gridData.verticalAlignment = 0x1000000;
            labelVbpOffset.setLayoutData((Object)gridData);
            gridData = new GridData(4, 0, false, false);
            gridData.horizontalAlignment = 0x1000008;
            this.textVbpOffset = new Text(cicsGroup, 2048);
            this.textVbpOffset.setLayoutData((Object)gridData);
            this.textVbpOffset.setTextLimit(20);
            this.textVbpOffset.setText("");
            TextUtil.setWidth(this.textVbpOffset, 6, 6);
        }
    }

    @Override
    public BreakpointMessage performFinish() {
        String var = null;
        int ix = this.vbpDataname.getSelectionIndex();
        var = ix >= 0 ? this.vbpDataname.getItem(ix) : this.vbpDataname.getText();
        this.attributes.put("left_variable", var);
        this.attributes.put("left_type", new Integer(1));
        this.attributes.put("left_value_len", this.getVariableLength(var));
        if (this.wizard.isCICS()) {
            String len = this.textVbpLength.getText();
            this.attributes.put("left_length_override", null);
            if (len != null && len.length() > 0) {
                try {
                    Integer iLen = Integer.valueOf(len);
                    this.attributes.put("left_length_override", iLen);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String off = this.textVbpOffset.getText();
            this.attributes.put("left_offset", null);
            if (off != null && off.length() > 0) {
                try {
                    Integer iLen = Integer.valueOf(off);
                    this.attributes.put("left_offset", iLen);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.attributes.put("sub_type", 0);
        this.attributes.put("message", this.getMarkerMessage(Messages.BreakpointProperties_variable_bp));
        return new VariableBreakpointMessage();
    }

    @Override
    public String getMarkerType() {
        return "com.ca.intertest.breakpoint.watch";
    }

    @Override
    public boolean isPageComplete() {
        String string;
        int ix = this.vbpDataname.getSelectionIndex();
        if (ix < 0) {
            string = this.vbpDataname.getText().toUpperCase();
            ix = this.vbpDataname.indexOf(string);
            if (ix >= 0) {
                this.vbpDataname.select(ix);
            } else {
                this.setErrorMessage(Messages.VariableBreakpointPage_6);
                return false;
            }
        }
        if (this.wizard.isCICS()) {
            string = this.textVbpLength.getText();
            if (string.length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.VariableBreakpointPage_7);
                    return false;
                }
            }
            if ((string = this.textVbpOffset.getText()).length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.VariableBreakpointPage_8);
                    return false;
                }
            }
        }
        return super.isPageComplete();
    }

    @Override
    public void preLoad() {
        String varName = (String)this.attributes.get("left_variable");
        if (varName == null) {
            return;
        }
        this.vbpDataname.select(this.vbpDataname.indexOf(varName));
        if (this.wizard.isCICS()) {
            Integer off;
            Integer len = (Integer)this.attributes.get("left_length_override");
            if (len != null && len > 0) {
                this.textVbpLength.setText(len.toString());
            }
            if ((off = (Integer)this.attributes.get("left_offset")) != null && off > 0) {
                this.textVbpOffset.setText(off.toString());
            }
        }
        this.preLoadOptions();
    }

    @Override
    protected void setFixedOptions(Composite options) {
    }

    @Override
    public void preLoadOptions() {
    }
}

