/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.CoreDumpPage;
import com.ca.intertest.wizards.IMemoryWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import com.ca.intertest.wizards.StorageData;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class StorageDisplayPage
extends WizardPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final int PrePageID = 1024;
    private static final int DumpID = 1025;
    private TableViewer viewer;
    private ListerEditor editor;
    private IResource resource;
    private Action doubleClickAction;
    private static final String COL_WIDTH = "column_width";
    private static final int[] COLUMN_WIDTHS = new int[]{8, 8, 10, 8, 8, 8, 8, 16};
    private int[] width = null;
    private Button filteredPush;
    private Button unfilteredPush;
    private boolean filter = true;
    private String cmd = "";
    private Text user24Text;
    private Text user31Text;
    private Text cics24Text;
    private Text cics31Text;
    private StorageData storage;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.storageDisplayPage";

    public StorageDisplayPage(String pageName) {
        super(pageName);
    }

    public void init(ListerEditor lsteditor) {
        this.editor = lsteditor;
        this.resource = lsteditor.getResource();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayoutData((Object)new GridData(272));
        composite.setLayout((Layout)layout);
        composite.setSize(composite.computeSize(-1, -1));
        this.checkWidth(composite);
        this.createTopGroup(composite);
        this.createButtonGroup(composite);
        this.viewer = new TableViewer(composite, 68356);
        Table storageTable = this.viewer.getTable();
        storageTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                StorageDisplayPage.this.cmd = StorageDisplayPage.this.getCmd((TreeObject)item.getData());
                StorageDisplayPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                StorageDisplayPage.this.cmd = StorageDisplayPage.this.getCmd((TreeObject)item.getData());
                StorageDisplayPage.this.getContainer().updateButtons();
            }
        });
        String[] labels = new String[]{Messages.StorageDisplayPage_4, Messages.StorageDisplayPage_5, Messages.StorageDisplayPage_6, Messages.StorageDisplayPage_7, Messages.StorageDisplayPage_8, Messages.StorageDisplayPage_9, Messages.StorageDisplayPage_10, Messages.StorageDisplayPage_11};
        int[] styles = new int[]{16385, 16384, 16384, 16384, 16384, 16384, 16384, 16384};
        int columnIndex = 0;
        while (columnIndex < labels.length) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new StorageColumnLabelProvider(columnIndex));
                    break;
                }
                default: {
                    column.setLabelProvider((CellLabelProvider)new StorageColumnLabelProvider(columnIndex));
                }
            }
            column.getColumn().setText(labels[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData(COL_WIDTH, (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            column.getColumn().setWidth(this.width[columnIndex]);
            column.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData(StorageDisplayPage.COL_WIDTH);
                        ((StorageDisplayPage)StorageDisplayPage.this).width[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++columnIndex;
        }
        storageTable.setHeaderVisible(true);
        storageTable.setLinesVisible(true);
        storageTable.setFont(JFaceResources.getTextFont());
        GridData data = new GridData(4, 4, true, true);
        storageTable.setLayoutData((Object)data);
        this.doStorageRequest();
        this.viewer.setContentProvider((IContentProvider)this.storage);
        this.viewer.setColumnProperties(labels);
        this.makeActions();
        this.hookDoubleClickAction();
        this.viewer.setInput((Object)this.storage);
        int tableheight = this.convertHeightInCharsToPixels(5);
        storageTable.setSize(storageTable.computeSize(-1, tableheight, true));
        composite.setSize(composite.computeSize(-1, -1, true));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.storageDisplayPage");
        this.setControl((Control)composite);
    }

    public void createTopGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.StorageDisplayPage_12);
        GridLayout groupLayout = new GridLayout(8, false);
        group.setLayout((Layout)groupLayout);
        GridData gridData = new GridData(32);
        group.setLayoutData((Object)gridData);
        Label user24Label = new Label((Composite)group, 0);
        user24Label.setText(Messages.StorageDisplayPage_13);
        gridData = new GridData(32);
        user24Label.setLayoutData((Object)gridData);
        this.user24Text = new Text((Composite)group, 2048);
        this.user24Text.setText(" ");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.user24Text.setTextLimit(8);
        this.user24Text.setEditable(false);
        this.user24Text.setLayoutData((Object)gridData);
        Label user31Label = new Label((Composite)group, 0);
        user31Label.setText(Messages.StorageDisplayPage_15);
        gridData = new GridData(32);
        user31Label.setLayoutData((Object)gridData);
        this.user31Text = new Text((Composite)group, 2048);
        this.user31Text.setText(" ");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.user31Text.setTextLimit(8);
        this.user31Text.setEditable(false);
        this.user31Text.setLayoutData((Object)gridData);
        Label cics24Label = new Label((Composite)group, 0);
        cics24Label.setText(Messages.StorageDisplayPage_17);
        gridData = new GridData(32);
        cics24Label.setLayoutData((Object)gridData);
        this.cics24Text = new Text((Composite)group, 2048);
        this.cics24Text.setText(" ");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.cics24Text.setTextLimit(8);
        this.cics24Text.setEditable(false);
        this.cics24Text.setLayoutData((Object)gridData);
        Label cics31Label = new Label((Composite)group, 0);
        cics31Label.setText(Messages.StorageDisplayPage_19);
        gridData = new GridData(32);
        cics31Label.setLayoutData((Object)gridData);
        this.cics31Text = new Text((Composite)group, 2048);
        this.cics31Text.setText(" ");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.cics31Text.setTextLimit(8);
        this.cics31Text.setEditable(false);
        this.cics31Text.setLayoutData((Object)gridData);
    }

    public void createButtonGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.StorageDisplayPage_21);
        GridLayout groupLayout = new GridLayout(2, false);
        group.setLayout((Layout)groupLayout);
        GridData gridData = new GridData(32);
        group.setLayoutData((Object)gridData);
        this.filteredPush = new Button((Composite)group, 8);
        gridData = new GridData(4, 0, true, false);
        this.filteredPush.setLayoutData((Object)gridData);
        this.filteredPush.setText(Messages.StorageDisplayPage_22);
        this.filteredPush.setEnabled(false);
        this.filteredPush.setToolTipText(Messages.StorageDisplayPage_23);
        this.filteredPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StorageDisplayPage.this.filter = true;
                StorageDisplayPage.this.doStorageRequest();
                StorageDisplayPage.this.filteredPush.setEnabled(false);
                StorageDisplayPage.this.unfilteredPush.setEnabled(true);
            }
        });
        this.unfilteredPush = new Button((Composite)group, 8);
        gridData = new GridData(4, 0, true, false);
        this.unfilteredPush.setLayoutData((Object)gridData);
        this.unfilteredPush.setText(Messages.StorageDisplayPage_24);
        this.unfilteredPush.setEnabled(true);
        this.unfilteredPush.setToolTipText(Messages.StorageDisplayPage_25);
        this.unfilteredPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StorageDisplayPage.this.filter = false;
                StorageDisplayPage.this.doStorageRequest();
                StorageDisplayPage.this.filteredPush.setEnabled(true);
                StorageDisplayPage.this.unfilteredPush.setEnabled(false);
            }
        });
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StorageDisplayPage.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = StorageDisplayPage.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeObject) {
                    StorageDisplayPage.this.cmd = StorageDisplayPage.this.getCmd((TreeObject)obj);
                    MemoryWizardDialog container = (MemoryWizardDialog)StorageDisplayPage.this.getContainer();
                    container.buttonPressed(1025);
                }
            }
        };
    }

    private void doStorageRequest() {
        this.storage = new StorageData(this.resource, this.filter);
        if (this.viewer.getContentProvider() != null) {
            this.viewer.setContentProvider((IContentProvider)this.storage);
            this.viewer.setInput((Object)this.storage);
            Table storageTable = this.viewer.getTable();
            storageTable.setSize(storageTable.computeSize(-1, -1));
            Control control = this.getControl();
            control.setSize(control.computeSize(-1, -1));
        }
        this.user24Text.setText(this.storage.getUser24());
        this.user31Text.setText(this.storage.getUser31());
        this.cics24Text.setText(this.storage.getCics24());
        this.cics31Text.setText(this.storage.getCics31());
    }

    public String getProgid() {
        return decorator.getShortName(this.resource);
    }

    public String getCmd(TreeObject treeobject) {
        return "/" + treeobject.getAddress().getAddrString() + "/00000000/00000000/" + treeobject.getAttribute("length") + "/";
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        CoreDumpPage dumpPage = (CoreDumpPage)this.getWizard().getPage(IMemoryWizard.dumppageName);
        dumpPage.initCmd(this.editor, this.cmd, false);
        return dumpPage;
    }

    private void checkWidth(Composite parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[COLUMN_WIDTHS.length];
            int j = 0;
            while (j < COLUMN_WIDTHS.length) {
                this.width[j] = COLUMN_WIDTHS[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.cmd.length() > 0;
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public class StorageColumnLabelProvider
    extends ColumnLabelProvider {
        private int cellIX;

        public StorageColumnLabelProvider(int columnIndex) {
            this.cellIX = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof TreeObject) {
                TreeObject tree = (TreeObject)element;
                switch (this.cellIX) {
                    case 0: {
                        String[] ss = tree.getName().split("-");
                        return ss[0];
                    }
                    case 1: {
                        return tree.getAddress().getLowString();
                    }
                    case 2: {
                        return "(" + tree.getAttribute("lth") + ")";
                    }
                    case 3: {
                        return tree.getAttribute("hex").substring(0, 8);
                    }
                    case 4: {
                        return tree.getAttribute("hex").substring(8, 16);
                    }
                    case 5: {
                        return tree.getAttribute("hex").substring(16, 24);
                    }
                    case 6: {
                        return tree.getAttribute("hex").substring(24, 32);
                    }
                    case 7: {
                        return tree.getAttribute("chars");
                    }
                    case 8: {
                        return tree.getAttribute("error");
                    }
                }
            }
            return " ";
        }
    }
}

