/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.tools.StorageRequestMessage;
import com.ca.intertest.tools.StorageReturnMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StorageData
implements ITreeContentProvider,
IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final Debug debug = Debug.getInstance();
    private IDebug debugitem;
    private debugSession session;
    public ArrayList<TreeObject> storageObjects = new ArrayList();
    private int user24 = 0;
    private int user31 = 0;
    private int cics24 = 0;
    private int cics31 = 0;
    protected int lowAddr = 0;
    protected int highAddr = 0;
    protected byte[] type;
    protected byte[] flg2;
    protected ArrayList<MFAddress> address;
    protected ArrayList<ByteBuffer> hexdata;
    protected ArrayList<Integer> length;
    private boolean filter = false;
    protected final String UniqueKey = Integer.toString(this.hashCode());

    public StorageData(IResource resource, boolean filter) {
        this.filter = filter;
        this.debugitem = debug.getResource(resource);
        this.session = debug.getSession((IResource)resource.getProject());
        this.debugitem.addPropertyChangeListener(this);
        this.sendStorageMemoryMessage();
    }

    public TreeObject[] findObjects(String name) {
        return null;
    }

    public boolean deleteObject(TreeObject treeobject) {
        return false;
    }

    public TreeObject getRootObject(TreeObject item) {
        if (item == null) {
            return null;
        }
        String markerid = item.getAttribute(this.getUniqueKey());
        if (markerid == null || markerid.length() == 0) {
            return this.getRootObject(item.getParent());
        }
        return item;
    }

    public boolean removeObject(TreeObject item) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)parentElement;
            return treeobject.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)element;
            if (treeobject.getAttribute(this.UniqueKey) != null) {
                return null;
            }
            return treeobject.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeObject) {
            return ((TreeObject)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.equals(inputElement)) {
            return this.storageObjects.toArray(new TreeObject[this.storageObjects.size()]);
        }
        return new TreeObject[0];
    }

    public void dispose() {
        this.debugitem.removePropertyChangeListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void sendStorageMemoryMessage() {
        StorageRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                msg = new StorageRequestMessage();
                msg.setSubmessageID((Object)(this.filter ? 0 : 1));
                cvmi.addMessage((DebugMessage)msg);
                cvmo = this.session.getTalker().process(cvmi);
                this.processCVMO(cvmo);
            }
            catch (Exception e) {
                Logger.loggit(e);
                TreeObject[] nullObj = new TreeObject[]{};
                this.storageObjects.add(nullObj[0]);
            }
        } else {
            TreeObject[] nullObj = new TreeObject[]{};
            this.storageObjects.add(nullObj[0]);
        }
    }

    protected void processCVMO(CVMO cvmo) {
        TreeObject treeobject = null;
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 43: {
                    StorageReturnMessage srmsg = (StorageReturnMessage)message;
                    this.user24 = srmsg.getUser24();
                    this.user31 = srmsg.getUser31();
                    this.cics24 = srmsg.getCics24();
                    this.cics31 = srmsg.getCics31();
                    int numEntries = srmsg.getNumEntries();
                    this.type = srmsg.getType();
                    this.flg2 = srmsg.getFlg2();
                    this.length = srmsg.getLength();
                    this.hexdata = srmsg.getHexdata();
                    this.address = srmsg.getAddress();
                    int i = 0;
                    while (i < numEntries) {
                        MFAddress addr = this.address.get(i);
                        String name = String.valueOf(this.getTypeText(this.type[i])) + "-" + addr.getLowString();
                        treeobject = new TreeObject(name, "1");
                        treeobject.setAttribute("level", "1");
                        treeobject.setAttribute("lth", HexUtil.toHex((int)this.length.get(i)));
                        treeobject.setAttribute("error", this.getFlg2Text(this.flg2[i]));
                        treeobject.setAddress(addr);
                        ByteBuffer bb = this.hexdata.get(i);
                        byte[] bytes = new byte[16];
                        bb.get(bytes);
                        treeobject.setAttribute("hex", HexUtil.toHex((byte[])bytes, (int)0));
                        treeobject.setAttribute("chars", HexUtil.toString((byte[])bytes, (boolean)true));
                        this.storageObjects.add(treeobject);
                        ++i;
                    }
                    break;
                }
                case 18: {
                    StatusMessage smsg = (StatusMessage)message;
                    Shell shell = Display.getDefault().getActiveShell();
                    String text = String.format(Messages.StorageData_9, smsg.getStatus(), smsg.getMessage());
                    MessageDialog.openWarning((Shell)shell, (String)Messages.StorageData_10, (String)text);
                    TreeObject[] nullObj = new TreeObject[]{};
                    this.storageObjects.add(nullObj[0]);
                }
            }
            ++n2;
        }
    }

    public String getTypeText(byte b) {
        switch (b) {
            case 1: {
                return Messages.StorageData_5;
            }
            case 2: {
                return Messages.StorageData_6;
            }
            case 3: {
                return Messages.StorageData_7;
            }
            case 4: {
                return Messages.StorageData_8;
            }
        }
        return Messages.StorageData_15;
    }

    public String getFlg2Text(byte b) {
        switch (b) {
            case 1: {
                return Messages.StorageData_16;
            }
        }
        return "";
    }

    public String getUniqueKey() {
        return this.UniqueKey;
    }

    public String getUser24() {
        return StorageData.doFormatBytes(this.user24);
    }

    public String getUser31() {
        return StorageData.doFormatBytes(this.user31);
    }

    public String getCics24() {
        return StorageData.doFormatBytes(this.cics24);
    }

    public String getCics31() {
        return StorageData.doFormatBytes(this.cics31);
    }

    public static String doFormatBytes(int test) {
        if (test == 0) {
            return "0.00 KB";
        }
        String suffix = " KB";
        Double divisor = 1024.0;
        long big = 0x100000L;
        if ((long)test >= big) {
            suffix = " MB";
            divisor = divisor * 1024.0;
        }
        Double dd = Double.valueOf(test) / Double.valueOf(divisor);
        Formatter fmt = new Formatter();
        fmt.format("%.2f", dd);
        return String.valueOf(fmt.toString()) + suffix;
    }

    public ArrayList<TreeObject> getStorageObjects() {
        return this.storageObjects;
    }
}

