/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.wizards.ImportListingWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ProjectCreationPage
extends WizardNewProjectCreationPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Combo serverid;
    private Text cicsapplid;
    private Button pl1;
    private Button getfiles;
    private Button defaultStatementTrace;
    private IWorkbench workbench;
    private StructuredSelection selection = null;
    public static final int CICS = 1;
    public static final int BATCH = 2;
    public static final String PAGE_NAME = Messages.ProjectCreationPage_PageName;
    private IProject project = null;
    private String defaultFileServer = "";
    private String defaultApplID = "";
    private int projtype = 0;
    private ServerList servers;
    private String projectTypeString;

    public ProjectCreationPage(IWorkbench workbench, IStructuredSelection selection, int projtype) {
        super(PAGE_NAME);
        this.workbench = workbench;
        if (selection != null && selection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)selection;
        }
        this.projtype = projtype;
        this.projectTypeString = projtype == 1 ? "CICS" : "BATCH";
        this.setTitle(String.format(Messages.ProjectCreationPage_Title, this.projectTypeString));
        this.setDescription(String.format(Messages.ProjectCreationPage_Description, this.projectTypeString));
    }

    public void createControl(Composite parent) {
        GridData data;
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        Group servergroup = new Group(composite, 0);
        GridLayout serverlayout = new GridLayout();
        serverlayout.numColumns = 2;
        servergroup.setLayout((Layout)serverlayout);
        servergroup.setText(Messages.SERVER_SETTINGS_TITLE);
        this.servers = ServerList.getInstance();
        new Label((Composite)servergroup, 0).setText(Messages.ProjectCreationPage_Server);
        this.serverid = new Combo((Composite)servergroup, 2060);
        String selection = Messages.NONE_SELECTED;
        int index = 0;
        this.serverid.add(selection, index++);
        for (FileServer element : this.servers.getFileServers()) {
            this.serverid.add(element.getName(), index++);
        }
        this.setDefaultFileServer(this.defaultFileServer);
        if (this.projtype == 1) {
            new Label((Composite)servergroup, 131072).setText(Messages.ProjectCreationPage_ApplID);
            this.cicsapplid = new Text((Composite)servergroup, 18440);
            this.cicsapplid.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.cicsapplid.setEditable(true);
        }
        this.setDefaultApplID(this.defaultApplID);
        if (this.projtype == 2) {
            this.pl1 = new Button(composite, 16416);
            this.pl1.setText(Messages.ProjectCreationPage_pliText);
            data = new GridData();
            this.pl1.setLayoutData((Object)data);
        }
        if (this.projtype == 1) {
            this.defaultStatementTrace = new Button(composite, 16416);
            this.defaultStatementTrace.setText(Messages.AbstractSettingsPage_9);
            this.defaultStatementTrace.setSelection(true);
            data = new GridData();
            this.defaultStatementTrace.setLayoutData((Object)data);
        }
        this.getfiles = new Button(composite, 16416);
        this.getfiles.setText(Messages.ProjectCreationPage_ImportFiles);
        data = new GridData();
        this.getfiles.setLayoutData((Object)data);
        this.getfiles.setEnabled(true);
        this.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        URI location = null;
        if (!this.useDefaults()) {
            location = this.getLocationURI();
        }
        this.project = this.getProjectHandle();
        IProjectDescription projectdesc = null;
        String[] natures = new String[]{"com.ca.intertest.natures.intertest", ""};
        natures[1] = this.projtype == 1 ? "com.ca.intertest.natures.cics" : "com.ca.intertest.natures.batch";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        projectdesc = workspace.newProjectDescription(this.project.getName());
        projectdesc.setLocationURI(location);
        projectdesc.setNatureIds(natures);
        int index = this.serverid.getSelectionIndex();
        String newserver = "";
        if (index > 0) {
            newserver = this.servers.getFileServer(this.serverid.getItem(index)).getUUIDString();
        }
        try {
            this.project.create(projectdesc, null);
            this.project.open(null);
            ResourceProperty store = ResourceProperty.getStore((IResource)this.project);
            store.setValue("PROJECT_TYPE", this.projectTypeString);
            store.setValue("com.ca.intertest.server", newserver);
            int UID = IntertestPlugin.generateUID();
            while (Debug.getInstance().getSession(UID) != null) {
                UID = IntertestPlugin.generateUID();
            }
            store.setValue("uid", UID);
            switch (this.projtype) {
                case 1: {
                    store.setValue("com.ca.intertest.applid", this.cicsapplid.getText());
                    break;
                }
                case 2: {
                    store.setValue("PL/I", this.pl1.getSelection());
                    store.setValue("com.ca.intertest.applid", newserver);
                }
            }
            store.save();
        }
        catch (Exception e) {
            this.ErrorMessage(HexUtil.getErrorText((Throwable)e), e);
            return false;
        }
        try {
            Debug.getInstance().addDebugSession((IResource)this.project);
            if (this.getfiles.getSelection()) {
                ImportListingWizard wizard = new ImportListingWizard();
                this.selection = new StructuredSelection((Object)this.project);
                wizard.init(this.workbench, (IStructuredSelection)this.selection);
                Shell shell = IntertestPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                IntertestWizardDialog dialog = new IntertestWizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            if (this.projtype == 1) {
                Debug.getInstance().getSession((IResource)this.project).setDefaultStatementTraceForAutomaticallyAddedPrograms(this.defaultStatementTrace.getSelection());
            }
        }
        catch (ITException e) {
            Logger.loggit(e);
            return false;
        }
        return true;
    }

    private void ErrorMessage(String text, Throwable e) {
        IT_ErrorDialog.openError(this.getShell(), this.getWizard().getWindowTitle(), text, e);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setDefaultApplID(String defaultApplID) {
        this.defaultApplID = defaultApplID;
    }

    public void setDefaultFileServer(String defaultFileServer) {
        this.defaultFileServer = defaultFileServer;
        if (this.serverid != null) {
            int ix = this.serverid.indexOf(defaultFileServer);
            if (ix < 0) {
                ix = 0;
            }
            this.serverid.clearSelection();
            this.serverid.select(ix);
        }
    }

    protected boolean validatePage() {
        File[] children;
        File file;
        IPath path;
        if (!super.validatePage()) {
            return false;
        }
        if (!this.useDefaults() && (path = this.getLocationPath()) != null && (file = path.toFile()) != null && (children = file.listFiles()) != null && children.length > 0) {
            this.setErrorMessage(Messages.ProjectCreationPage_0);
            return false;
        }
        return true;
    }
}

