/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDSN;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.dialogs.MRUCombo;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.LoadProtsymMessage;
import com.ca.intertest.wizards.LoadProtsymWizard;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoadProtsymPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private StatusMessage status;
    private ArrayList<FileServer> serverlist;
    private LoadProtsymWizard wizard;
    private Combo servers;
    private MRUCombo ProtsymDSN;
    private MRUCombo SourceDSN;
    private Combo SourceType;
    private Text from;
    private Text to;
    private Button all;
    private Button none;
    private Button rc;
    private IDialogSettings settings;
    private static final String SERVERNAME = "Server";
    private static final String PROTSYM = "PROTSYM";
    private static final String SOURCE = "SOURCE";
    private static final String FILETYPE = "filetype";
    private static final String FROMNAME = "fromname";
    private static final String TONAME = "toname";
    private static final String REPORTTYPE = "reporttype";
    private final String CONTEXT_HELP_ID = "com.ca.intertest.loadProtsymPage";
    private String errorText = null;
    private FileServer server = null;
    private String[] dsnTypeLabels = new String[]{Messages.FileTypePDS, Messages.FileTypeSEQ, Messages.FileTypePanvalet, Messages.FileTypeLibrarian, Messages.FileTypeEndevor};

    protected LoadProtsymPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Byte type;
        this.wizard = (LoadProtsymWizard)this.getWizard();
        this.settings = this.wizard.getDialogSettings();
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        control.setLayout((Layout)gridLayout);
        this.serverlist = ServerList.getInstance().getFileServers();
        Group servergroup = new Group(control, 16);
        servergroup.setLayout((Layout)new GridLayout(1, true));
        servergroup.setText(Messages.LoadProtsymPage_5);
        this.servers = new Combo((Composite)servergroup, 2060);
        for (FileServer item : this.serverlist) {
            this.servers.add(item.getName());
        }
        String servername = this.settings.get(SERVERNAME);
        int index = servername == null ? -1 : this.servers.indexOf(servername);
        this.servers.select(index);
        Group protsym = new Group(control, 16);
        protsym.setLayout((Layout)new GridLayout(1, true));
        protsym.setText(Messages.LoadProtsymPage_6);
        this.ProtsymDSN = new MRUCombo((Composite)protsym, 4, PROTSYM);
        Combo combo = this.ProtsymDSN.getCombo();
        combo.setTextLimit(44);
        TextUtil.setWidth(this.ProtsymDSN.getCombo(), 20, 44);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        String name = this.settings.get(PROTSYM);
        index = name == null ? -1 : combo.indexOf(name);
        combo.select(index);
        Group source = new Group(control, 16);
        source.setLayout((Layout)new GridLayout(1, true));
        source.setText(Messages.LoadProtsymPage_7);
        this.SourceDSN = new MRUCombo((Composite)source, 4, SOURCE);
        this.SourceDSN.getCombo().setTextLimit(44);
        combo = this.SourceDSN.getCombo();
        TextUtil.setWidth(combo, 20, 44);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        name = this.settings.get(SOURCE);
        index = name == null ? -1 : combo.indexOf(name);
        combo.select(index);
        this.SourceType = new Combo((Composite)source, 12);
        this.SourceType.setLayoutData((Object)new GridData(16384, 0, true, false));
        this.SourceType.setItems(this.dsnTypeLabels);
        try {
            type = new Byte(new Integer(this.settings.getInt(FILETYPE)).byteValue());
        }
        catch (NumberFormatException numberFormatException) {
            type = 1;
        }
        name = IConstants.FileTypesNames.get(type);
        index = name == null ? -1 : this.SourceType.indexOf(name);
        this.SourceType.select(index);
        Composite remaining = control;
        Group members = new Group(remaining, 16);
        members.setLayout((Layout)new GridLayout(2, false));
        members.setText(Messages.LoadProtsymPage_8);
        Label label = new Label((Composite)members, 0);
        label.setText(Messages.LoadProtsymPage_9);
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.from = new Text((Composite)members, 4);
        name = this.settings.get(FROMNAME);
        this.from.setText(name == null ? "" : name);
        this.from.setTextLimit(10);
        TextUtil.setWidth(this.from, 8, 10);
        this.from.addVerifyListener(new VerifyListener(){
            private Pattern p = Pattern.compile("[*_0-9A-Z]+");

            public void verifyText(VerifyEvent e) {
                int length = e.text.length();
                if (length == 0) {
                    return;
                }
                e.text = e.text.toUpperCase();
                Matcher m = this.p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        label = new Label((Composite)members, 0);
        label.setText(Messages.LoadProtsymPage_12);
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.to = new Text((Composite)members, 4);
        name = this.settings.get(TONAME);
        this.to.setText(name == null ? "" : name);
        this.to.setTextLimit(10);
        TextUtil.setWidth(this.to, 8, 10);
        this.to.addVerifyListener(new VerifyListener(){
            private Pattern p = Pattern.compile("[_0-9A-Z]+");

            public void verifyText(VerifyEvent e) {
                int length = e.text.length();
                if (length == 0) {
                    return;
                }
                e.text = e.text.toUpperCase();
                Matcher m = this.p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        Group reportgroup = new Group(remaining, 16);
        reportgroup.setLayout((Layout)new GridLayout(3, false));
        reportgroup.setText(Messages.LoadProtsymPage_15);
        this.all = new Button((Composite)reportgroup, 16);
        this.all.setText(Messages.LoadProtsymPage_16);
        this.none = new Button((Composite)reportgroup, 16);
        this.none.setText(Messages.LoadProtsymPage_17);
        this.rc = new Button((Composite)reportgroup, 16);
        this.rc.setText(Messages.LoadProtsymPage_18);
        try {
            int reptype = this.settings.getInt(REPORTTYPE);
            switch (reptype) {
                case 0: {
                    this.none.setSelection(true);
                    break;
                }
                case 2: {
                    this.rc.setSelection(true);
                    break;
                }
                default: {
                    this.all.setSelection(true);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.all.setSelection(true);
        }
        this.servers.forceFocus();
        this.servers.addSelectionListener((SelectionListener)this);
        this.ProtsymDSN.getCombo().addSelectionListener((SelectionListener)this);
        this.ProtsymDSN.getCombo().addModifyListener((ModifyListener)this);
        this.SourceDSN.getCombo().addSelectionListener((SelectionListener)this);
        this.SourceDSN.getCombo().addModifyListener((ModifyListener)this);
        this.all.addSelectionListener((SelectionListener)this);
        this.none.addSelectionListener((SelectionListener)this);
        this.rc.addSelectionListener((SelectionListener)this);
        this.from.addModifyListener((ModifyListener)this);
        this.to.addModifyListener((ModifyListener)this);
        this.SourceType.addSelectionListener((SelectionListener)this);
        this.setTitle(Messages.LoadProtsymPage_19);
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.loadProtsymPage");
    }

    public boolean submit() {
        if (this.isPageComplete()) {
            this.ProtsymDSN.save();
            this.SourceDSN.save();
            this.setErrorMessage(null);
            int ix = this.servers.getSelectionIndex();
            if (ix < 0) {
                this.showError(Messages.LoadProtsymPage_20);
                return false;
            }
            String name = this.servers.getItem(ix);
            this.server = ServerList.getInstance().getFileServer(name);
            if (this.server == null) {
                this.showError(Messages.LoadProtsymPage_21);
                return false;
            }
            LoadProtsymMessage load = new LoadProtsymMessage();
            load.setProtsymDSN(this.ProtsymDSN.getSelected());
            if (this.all.getSelection()) {
                load.setReportType((byte)1);
            } else if (this.none.getSelection()) {
                load.setReportType((byte)0);
            } else {
                load.setReportType((byte)2);
            }
            int index = this.SourceType.getSelectionIndex();
            Byte type = 1;
            if (index >= 0) {
                String sel = this.SourceType.getItem(index);
                type = IConstants.FileTypes.get(sel);
            }
            load.setSourcefile(new FileName(type.byteValue(), this.SourceDSN.getSelected()));
            load.setFromMember(this.from.getText());
            load.setToMember(this.to.getText());
            IWizardContainer container = this.getContainer();
            LoadPROTSYM loadlisting = new LoadPROTSYM(load);
            try {
                container.run(true, true, (IRunnableWithProgress)loadlisting);
            }
            catch (InvocationTargetException e) {
                Logger.loggit(e);
                this.showError(Messages.LoadProtsymPage_22, e);
                return false;
            }
            catch (InterruptedException e) {
                Logger.loggit(e);
                String error = HexUtil.getErrorText((Throwable)e);
                this.showError(error, e);
                return false;
            }
            this.settings.put(SERVERNAME, this.server.getName());
            this.settings.put(PROTSYM, load.getProtsymDSN());
            this.settings.put(SOURCE, load.getSourcetDSN());
            this.settings.put(FILETYPE, (int)load.getSourceFiletype());
            this.settings.put(FROMNAME, load.getFromMember());
            this.settings.put(TONAME, load.getToMember());
            this.settings.put(REPORTTYPE, (int)load.getReportType());
            return true;
        }
        return false;
    }

    public String getMessage() {
        return this.status == null ? Messages.LoadProtsymPage_24 : this.status.getMessage(false);
    }

    public String[] getMessages() {
        if (this.status == null) {
            return new String[0];
        }
        return this.status.getMessages();
    }

    public short getStatus() {
        if (this.status == null) {
            return -1;
        }
        return this.status.getStatus();
    }

    public boolean isPageComplete() {
        int last;
        this.setErrorMessage(null);
        if (this.servers.getItemCount() < 1) {
            this.setErrorMessage(Messages.LoadProtsymPage_25);
            return false;
        }
        if (this.servers.getSelectionIndex() < 0) {
            this.setErrorMessage(Messages.LoadProtsymPage_26);
            return false;
        }
        if (this.ProtsymDSN.getSelected() == null) {
            this.setErrorMessage(Messages.LoadProtsymPage_27);
            return false;
        }
        if (this.SourceDSN.getSelected() == null) {
            this.setErrorMessage(Messages.LoadProtsymPage_28);
            return false;
        }
        String member = this.from.getText().trim();
        if (member.length() < 1) {
            this.setErrorMessage(Messages.LoadProtsymPage_29);
            return false;
        }
        if (member.length() > 8 && !this.SourceType.getText().equals(Messages.FileTypePanvalet)) {
            this.setErrorMessage(Messages.LoadProtsymPage_30);
            return false;
        }
        int first = member.indexOf(42);
        if (first != (last = member.lastIndexOf(42))) {
            this.setErrorMessage(Messages.LoadProtsymPage_31);
            return false;
        }
        boolean wildcard = false;
        if (last >= 0 && last == member.length() - 1) {
            wildcard = true;
        } else if (last >= 0) {
            this.setErrorMessage(Messages.LoadProtsymPage_32);
            return false;
        }
        if (this.SourceType.getText().equals(Messages.FileTypeSEQ) && wildcard) {
            this.setErrorMessage(Messages.LoadProtsymPage_33);
            return false;
        }
        String tomember = this.to.getText().trim();
        if (tomember.length() > 0 && wildcard) {
            this.setErrorMessage(Messages.LoadProtsymPage_34);
            return false;
        }
        if (tomember.length() > 8 && !this.SourceType.getText().equals(Messages.FileTypePanvalet)) {
            this.setErrorMessage(Messages.LoadProtsymPage_35);
            return false;
        }
        if (tomember.length() > 0) {
            try {
                ByteBuffer from = ByteBuffer.wrap(member.getBytes("IBM1047"));
                ByteBuffer to = ByteBuffer.wrap(tomember.getBytes("IBM1047"));
                if (from.compareTo(to) >= 0) {
                    this.setErrorMessage(Messages.LoadProtsymPage_36);
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (this.SourceType.getText().equals(Messages.FileTypeSEQ) && tomember.length() > 0) {
            this.setErrorMessage(Messages.LoadProtsymPage_37);
            return false;
        }
        return super.isPageComplete();
    }

    private void showError(String text, Throwable e) {
        IT_ErrorDialog.openError(this.getShell(), this.getWizard().getWindowTitle(), text, e);
    }

    private void showError(String message) {
        this.errorText = message;
        this.setErrorMessage(message);
        MessageDialog.openError((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    private void showWarning(String message) {
        this.errorText = message;
        this.setMessage(message, 2);
        MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    public void modifyText(ModifyEvent e) {
        this.wizard.getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.wizard.getContainer().updateButtons();
    }

    public class LoadPROTSYM
    implements IRunnableWithProgress {
        LoadProtsymMessage load;

        public LoadPROTSYM(LoadProtsymMessage load) {
            this.load = load;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.LoadProtsymPage_39, 2);
            FileConnection connection = new FileConnection(LoadProtsymPage.this.server);
            monitor.subTask(Messages.LoadProtsymPage_40);
            try {
                connection.connect(true);
                monitor.worked(1);
                CVMI cvmi = new CVMI();
                cvmi.addMessage((DebugMessage)this.load);
                monitor.subTask(Messages.LoadProtsymPage_41);
                CVMO cvmo = connection.processTomcat(true, new HashMap<String, Object>(), cvmi);
                monitor.worked(1);
                int errorLevel = connection.getErrorLevel();
                LoadProtsymPage.this.errorText = connection.getErrorMessage();
                if (errorLevel > 8 || cvmo == null) {
                    throw new InterruptedException(String.format(Messages.LoadProtsymPage_42, errorLevel, LoadProtsymPage.this.errorText));
                }
                if (cvmo != null) {
                    DebugMessage msg = cvmo.getMessage(1);
                    if (msg instanceof StatusMessage) {
                        LoadProtsymPage.this.status = (StatusMessage)msg;
                    } else {
                        LoadProtsymPage.this.status = new StatusMessage();
                        LoadProtsymPage.this.status.setMessage(Messages.LoadProtsymPage_43);
                        LoadProtsymPage.this.status.setStatus((short)12);
                    }
                } else {
                    LoadProtsymPage.this.status = new StatusMessage();
                    LoadProtsymPage.this.status.setMessage(LoadProtsymPage.this.errorText);
                    LoadProtsymPage.this.status.setStatus((short)errorLevel);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
                throw new InterruptedException(String.format(Messages.LoadProtsymPage_44, connection.getServer().getName(), connection.getErrorLevel(), connection.getErrorMessage()));
            }
        }
    }
}

