/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.ChannelData;
import com.ca.intertest.wizards.CoreDumpPage;
import com.ca.intertest.wizards.IMemoryWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ChannelDisplayPage
extends WizardPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final int PrePageID = 1024;
    public static final int DumpID = 1025;
    private TreeViewer viewer;
    private ListerEditor editor;
    private IResource resource;
    private Action doubleClickAction;
    private static final String COL_WIDTH = "column_width";
    private static final int[] COLUMN_WIDTHS = new int[]{24, 5, 7, 7, 28};
    private int[] width = null;
    private ChannelData channel;
    private String cmd = "";
    private final String CONTEXT_HELP_ID = "com.ca.intertest.channelDisplayPage";

    public ChannelDisplayPage(String pageName) {
        super(pageName);
    }

    public void init(ListerEditor lsteditor) {
        this.editor = lsteditor;
        this.resource = lsteditor.getResource();
    }

    public void createControl(Composite parent) {
        this.checkWidth(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.viewer = new TreeViewer(composite, 68356);
        GridData data = new GridData(1808);
        int fWidth = 80;
        int fHeight = 16;
        data.widthHint = this.convertWidthInCharsToPixels(fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(fHeight);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)data);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                ChannelDisplayPage.this.cmd = ChannelDisplayPage.this.getCmd((TreeObject)item.getData());
                ChannelDisplayPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                ChannelDisplayPage.this.cmd = ChannelDisplayPage.this.getCmd((TreeObject)item.getData());
                ChannelDisplayPage.this.getContainer().updateButtons();
            }
        });
        String[] labels = new String[]{Messages.ChannelDisplayPage_4, Messages.ChannelDisplayPage_5, Messages.ChannelDisplayPage_6, Messages.ChannelDisplayPage_7, Messages.ChannelDisplayPage_8};
        int[] styles = new int[]{16385, 16384, 16384, 16384, 16384};
        int columnIndex = 0;
        while (columnIndex < labels.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new ContainerColumnLabelProvider(columnIndex));
                    break;
                }
                default: {
                    column.setLabelProvider((CellLabelProvider)new ContainerColumnLabelProvider(columnIndex));
                }
            }
            column.getColumn().setText(labels[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData(COL_WIDTH, (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            column.getColumn().setWidth(this.width[columnIndex]);
            column.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    TreeColumn column = (TreeColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData(ChannelDisplayPage.COL_WIDTH);
                        ((ChannelDisplayPage)ChannelDisplayPage.this).width[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++columnIndex;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.setAutoExpandLevel(2);
        this.channel = new ChannelData(this.resource, this.editor);
        this.viewer.setContentProvider((IContentProvider)this.channel);
        this.viewer.setColumnProperties(labels);
        this.makeActions();
        this.hookDoubleClickAction();
        this.viewer.setInput((Object)this.channel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.channelDisplayPage");
        this.setControl((Control)composite);
    }

    private void checkWidth(Composite parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[COLUMN_WIDTHS.length];
            int j = 0;
            while (j < COLUMN_WIDTHS.length) {
                this.width[j] = COLUMN_WIDTHS[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChannelDisplayPage.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ChannelDisplayPage.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeObject) {
                    ChannelDisplayPage.this.cmd = ChannelDisplayPage.this.getCmd((TreeObject)obj);
                    MemoryWizardDialog container = (MemoryWizardDialog)ChannelDisplayPage.this.getContainer();
                    container.buttonPressed(1025);
                }
            }
        };
    }

    public String getCmd(TreeObject treeobject) {
        return "/" + treeobject.getAddress().getAddrString() + "/00000000/00000000/" + treeobject.getAttribute("length") + "/";
    }

    public String getProgid() {
        return decorator.getShortName(this.resource);
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        CoreDumpPage dumpPage = (CoreDumpPage)this.getWizard().getPage(IMemoryWizard.dumppageName);
        dumpPage.initCmd(this.editor, this.cmd, false);
        return dumpPage;
    }

    public boolean isPageComplete() {
        boolean ok;
        boolean bl = ok = this.channel != null && this.channel.getElements(null).length > 0;
        if (!ok) {
            this.setErrorMessage(Messages.ChannelDisplayPage_21);
        } else {
            this.setErrorMessage(null);
        }
        return ok;
    }

    public boolean canFlipToNextPage() {
        if (this.isPageComplete()) {
            return this.cmd.length() > 0;
        }
        return false;
    }

    public class ContainerColumnLabelProvider
    extends ColumnLabelProvider {
        private int cellIX;

        public ContainerColumnLabelProvider(int columnIndex) {
            this.cellIX = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof TreeObject) {
                TreeObject tree = (TreeObject)element;
                if (!tree.getAttribute("level").equals("1")) {
                    switch (this.cellIX) {
                        case 0: {
                            return tree.getName();
                        }
                        case 1: {
                            return "   " + tree.getAttribute("curr");
                        }
                        case 2: {
                            return tree.getAttribute("cpgid");
                        }
                        case 3: {
                            return tree.getAttribute("length");
                        }
                        case 4: {
                            return tree.getAttribute("data");
                        }
                    }
                } else if (this.cellIX == 0) {
                    return tree.getName();
                }
            }
            return " ";
        }
    }
}

