/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.wizards.AbstractSettingsWizard;
import com.ca.intertest.wizards.CICSSettingsPage;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizardPage;

public class CICSSettingsWizard
extends AbstractSettingsWizard {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    ServerElement server;
    CICSSettingsPage settingsPage = null;

    public CICSSettingsWizard(debugSession session, boolean submit) {
        super(session, submit);
        this.server = session.getServer();
    }

    @Override
    public void addPages() {
        String projName = this.session.getName();
        this.settingsPage = new CICSSettingsPage("CICS", String.valueOf(Messages.CICSSettingsWizard_0) + projName, null);
        this.addPage((IWizardPage)this.settingsPage);
    }

    @Override
    public boolean performSubmit() {
        if (!this.checkApplID()) {
            this.settingsPage.setErrorMessage("Could not connect to the CICS with Application ID " + this.settingsPage.getApplID());
            return false;
        }
        return super.performSubmit();
    }

    protected boolean checkApplID() {
        String applID = this.settingsPage.getApplID();
        String apacheServerName = this.server.getName();
        TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
        ServerConnect connection = new ServerConnect(apacheServer, "intertest/server");
        XMLRequest xmlResponse = null;
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("applid", applID);
        try {
            xmlResponse = connection.connect("cicscheck", map, true);
        }
        catch (TTException e) {
            e.printStackTrace();
            return false;
        }
        return xmlResponse.getErrorLevel() <= 0;
    }
}

