/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.AbstractBreakpointPage;
import com.ca.intertest.wizards.AbstractBreakpointWizard;
import com.ca.intertest.wizards.ConditionalBreakpointPage;
import com.ca.intertest.wizards.UnconditionalBreakpointPage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class CICSLineBreakpointWizard
extends AbstractBreakpointWizard {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private boolean cbpExists = false;
    private boolean ubpExists = false;

    public CICSLineBreakpointWizard(ListerEditor editor, Object object) {
        super(editor, object);
        this.setBreakpointpages(new AbstractBreakpointPage[]{new UnconditionalBreakpointPage(this), new ConditionalBreakpointPage(this)});
        this.setMarkersExist();
    }

    private void setMarkersExist() {
        IMarker[] iMarkerArray = this.getMarkers();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker mrkr = iMarkerArray[n2];
            try {
                Boolean enabled = (Boolean)mrkr.getAttribute("BREAKPOINT_ENABLED");
                Integer mrkrStmt = mrkr.getAttribute("stmtNumber", 0);
                if (enabled.booleanValue() && mrkrStmt.equals(this.stmtNumber)) {
                    String type = mrkr.getType();
                    if (type.equals("com.ca.intertest.breakpoint.conditional")) {
                        this.cbpExists = true;
                    } else if (type.equals("com.ca.intertest.breakpoint.unconditional")) {
                        this.ubpExists = true;
                    }
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++n2;
        }
    }

    public final boolean isCbpExists() {
        return this.cbpExists;
    }

    public final boolean isUbpExists() {
        return this.ubpExists;
    }
}

