/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.TerminateProgramMessage;
import com.ca.intertest.wizards.DebugDisconnectPage;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CICSDebugDisconnectPage
extends DebugDisconnectPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Button suspend;
    private Button removebkpts;
    private Button removemonitor;
    private Button nodump;
    private Button standard;
    private Button userdefined;
    private Group suspendgroup;
    private Group abendgroup;
    private Text usercode;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.cicsDebugDisconnectPage";

    public CICSDebugDisconnectPage(String pageName, debugSession session) {
        super(pageName, session);
    }

    @Override
    public boolean doFinish() {
        Job initJob = this.session.getInitializationJob();
        if (initJob != null) {
            initJob.cancel();
        }
        if (this.suspend.getSelection()) {
            this.session.suspendSession();
        } else if (this.removebkpts.getSelection()) {
            this.session.sendUnsetBreakpointsMessages();
            this.session.suspendSession();
        } else if (this.removemonitor.getSelection()) {
            this.session.sendUnsetMonitorMessages();
            this.session.suspendSession();
        } else if (this.nodump.getSelection()) {
            this.AbendTask("    ");
        } else if (this.standard.getSelection()) {
            this.AbendTask("XXXX");
        } else if (this.userdefined.getSelection()) {
            this.AbendTask(this.usercode.getText());
        } else {
            return false;
        }
        return true;
    }

    private void AbendTask(String code) {
        CVMI cvmi = new CVMI();
        try {
            TerminateProgramMessage message = new TerminateProgramMessage();
            message.setABENDCode(code);
            message.setProgram(this.session.getTalker().getBreakmessage().getProgram());
            cvmi.addMessage((DebugMessage)message);
            this.session.getTalker().processExecute(cvmi);
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void createControl(Composite parent) {
        Button button;
        Control child;
        int n;
        int n2;
        Control[] controlArray;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Group radiobuttons = new Group(composite, 0);
        GridData gd_radiobuttons = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_radiobuttons.widthHint = 360;
        radiobuttons.setLayoutData((Object)gd_radiobuttons);
        layout = new GridLayout(1, false);
        radiobuttons.setLayout((Layout)layout);
        radiobuttons.setText(Messages.CICSDebugDisconnectPage_1);
        this.suspendgroup = new Group((Composite)radiobuttons, 0);
        this.suspendgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.suspendgroup.setText(Messages.CICSDebugDisconnectPage_2);
        GridLayout layout3 = new GridLayout(2, false);
        this.suspendgroup.setLayout((Layout)layout3);
        this.suspend = new Button((Composite)this.suspendgroup, 16);
        this.suspend.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.suspend.setText(Messages.CICSDebugDisconnectPage_3);
        this.suspend.setToolTipText(Messages.CICSDebugDisconnectPage_4);
        this.removebkpts = new Button((Composite)this.suspendgroup, 16);
        this.removebkpts.setText(Messages.CICSDebugDisconnectPage_5);
        this.removebkpts.setToolTipText(Messages.CICSDebugDisconnectPage_6);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.removebkpts.setLayoutData((Object)layoutData);
        this.removemonitor = new Button((Composite)this.suspendgroup, 16);
        this.removemonitor.setSelection(true);
        this.removemonitor.setText(Messages.CICSDebugDisconnectPage_7);
        this.removemonitor.setToolTipText(Messages.CICSDebugDisconnectPage_8);
        GridData layoutData2 = new GridData();
        layoutData2.horizontalSpan = 2;
        this.removemonitor.setLayoutData((Object)layoutData2);
        this.abendgroup = new Group((Composite)radiobuttons, 0);
        this.abendgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.abendgroup.setText(Messages.CICSDebugDisconnectPage_9);
        GridLayout layout5 = new GridLayout(2, false);
        this.abendgroup.setLayout((Layout)layout5);
        this.nodump = new Button((Composite)this.abendgroup, 16);
        this.nodump.setText(Messages.CICSDebugDisconnectPage_10);
        this.nodump.setToolTipText(Messages.CICSDebugDisconnectPage_11);
        GridData layoutData3 = new GridData();
        layoutData3.grabExcessHorizontalSpace = true;
        layoutData3.horizontalSpan = 2;
        this.nodump.setLayoutData((Object)layoutData3);
        this.standard = new Button((Composite)this.abendgroup, 16);
        this.standard.setText(Messages.CICSDebugDisconnectPage_12);
        this.standard.setToolTipText(Messages.CICSDebugDisconnectPage_13);
        GridData layoutData4 = new GridData();
        layoutData4.horizontalSpan = 2;
        this.standard.setLayoutData((Object)layoutData4);
        this.userdefined = new Button((Composite)this.abendgroup, 16);
        this.userdefined.setText(Messages.CICSDebugDisconnectPage_14);
        this.userdefined.setToolTipText(Messages.CICSDebugDisconnectPage_15);
        this.usercode = new Text((Composite)this.abendgroup, 0);
        this.usercode.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.usercode.setTextLimit(4);
        this.usercode.addSelectionListener(this.selectionlistener);
        if (!this.session.isAtBreakpoint()) {
            controlArray = this.abendgroup.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                child = controlArray[n];
                if (child instanceof Button && ((button = (Button)child).getStyle() & 0x10) != 0) {
                    button.setEnabled(false);
                }
                ++n;
            }
        } else {
            controlArray = this.suspendgroup.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                child = controlArray[n];
                if (child instanceof Button && ((button = (Button)child).getStyle() & 0x10) != 0) {
                    button.setEnabled(false);
                }
                ++n;
            }
        }
        final Composite[] composites = new Composite[]{this.abendgroup, this.suspendgroup};
        SelectionListener radioGroup = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Composite[] compositeArray = composites;
                int n = composites.length;
                int n2 = 0;
                while (n2 < n) {
                    Composite comp = compositeArray[n2];
                    Control[] controlArray = comp.getChildren();
                    int n3 = controlArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Button button;
                        Control child = controlArray[n4];
                        if (child instanceof Button && ((button = (Button)child).getStyle() & 0x10) != 0) {
                            button.setSelection(false);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                Button button = (Button)event.widget;
                button.setSelection(true);
                CICSDebugDisconnectPage.this.getWizard().getContainer().updateButtons();
            }
        };
        Composite[] compositeArray = composites;
        int n3 = composites.length;
        int n4 = 0;
        while (n4 < n3) {
            Composite comp = compositeArray[n4];
            Control[] controlArray2 = comp.getChildren();
            int n5 = controlArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                Button button2;
                Control child2 = controlArray2[n6];
                if (child2 instanceof Button && ((button2 = (Button)child2).getStyle() & 0x10) != 0) {
                    button2.addSelectionListener(radioGroup);
                }
                ++n6;
            }
            ++n4;
        }
        composite.setSize(composite.computeSize(-1, -1));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.cicsDebugDisconnectPage");
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        if (this.suspend.getSelection()) {
            return true;
        }
        if (this.removebkpts.getSelection()) {
            return true;
        }
        if (this.removemonitor.getSelection()) {
            return true;
        }
        if (this.nodump.getSelection()) {
            return true;
        }
        if (this.standard.getSelection()) {
            return true;
        }
        if (this.userdefined.getSelection()) {
            return true;
        }
        this.setErrorMessage(Messages.CICSDebugDisconnectPage_16);
        return false;
    }
}

