/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.MemoryUpdate;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.verifyHexFixed;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class HexValueEditingSupport
extends BasicEditingSupport {
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    public HexValueEditingSupport(ColumnViewer viewer, debugSession session, debugFile debugfile, int columnIndex) {
        super(viewer, session, debugfile, columnIndex);
    }

    @Override
    protected boolean canEdit(Object element) {
        if (this.isBackTraceStop()) {
            return false;
        }
        if (this.session.isAtBreakpoint() && element instanceof Variable) {
            if (((TreeObject)element).getBackingdata() == null) {
                return false;
            }
            return ((Variable)element).canEditHex();
        }
        return this.session.isAtBreakpoint() && element instanceof TreeObject && "CORE_EXPRESSION".equals(((TreeObject)element).getAttribute("dataflag"));
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        TextCellEditor celleditor = new TextCellEditor((Composite)((TreeViewer)this.getViewer()).getTree());
        Text text = (Text)celleditor.getControl();
        text.setMenu(this.getViewer().getControl().getMenu());
        text.addVerifyListener((VerifyListener)new verifyHexFixed());
        text.addVerifyListener((VerifyListener)new verifyHexFixed());
        text.setTextLimit(this.getValue(element).toString().length());
        this.setEditorFont((CellEditor)celleditor);
        return celleditor;
    }

    @Override
    protected Object getValue(Object element) {
        TreeObject treeobject;
        if (element instanceof Variable) {
            try {
                return ((Variable)element).getHexValue();
            }
            catch (Exception exception) {
                return HexUtil.null2hex((int)((Variable)element).getLength());
            }
        }
        if (element instanceof TreeObject && "CORE_EXPRESSION".equals((treeobject = (TreeObject)element).getAttribute("dataflag"))) {
            return treeobject.getHexString();
        }
        return HexUtil.null2hex((int)1);
    }

    @Override
    protected void setValue(Object element, Object object) {
        TreeObject treeobject;
        if (object == null) {
            return;
        }
        String value = (String)object;
        if (element instanceof Variable) {
            Variable variable = (Variable)element;
            if (value.equals((String)this.getValue(element))) {
                return;
            }
            String msg = null;
            try {
                variable.updateHexValue(this.session, value);
            }
            catch (Exception e) {
                msg = String.format(Messages.HexValueEditingSupport_2, HexUtil.getErrorText((Throwable)e));
            }
            if (msg != null) {
                MessageDialog.openError(null, (String)Messages.HexValueEditingSupport_1, (String)msg);
            }
            super.setValue(element, this.getValue(element));
            return;
        }
        if (element instanceof TreeObject && "CORE_EXPRESSION".equals((treeobject = (TreeObject)element).getAttribute("dataflag"))) {
            String oldvalue = HexUtil.stripSpaces((String)treeobject.getHexString());
            String newvalue = HexUtil.stripSpaces((String)value);
            if (newvalue.equals(oldvalue)) {
                return;
            }
            MemoryUpdate memory = new MemoryUpdate(this.session);
            memory.sendMemoryUpdateMessage(newvalue, oldvalue, treeobject.getAddress());
        }
    }
}

