/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.ITreeView;
import com.ca.intertest.common.MemoryUpdateTable;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.actions.ChangeKeepItemAction;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.ui.views.data.HexValueColumnLabelProvider;
import com.ca.intertest.ui.views.data.HexValueEditingSupport;
import com.ca.intertest.ui.views.data.PropertyColumnLabelProvider;
import com.ca.intertest.ui.views.data.ValueColumnLabelProvider;
import com.ca.intertest.ui.views.data.ValueEditingSupport;
import com.ca.intertest.ui.views.data.VariableColumnLabelProvider;
import com.ca.intertest.ui.views.data.ViewData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class AbstractDataViewPage
extends Page
implements IPageBookViewPage,
IAdaptable,
ITreeView {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    protected static final Debug debug = Debug.getInstance();
    protected int lang;
    protected debugSession session;
    protected debugFile debugfile;
    protected Control control;
    protected IDebug debugitem;
    protected ListerEditor editor = null;
    protected ViewData contentprovider = null;
    protected final ArrayList<TreeObject> keptObjects = new ArrayList();
    protected final String UniqueKey = Integer.toString(this.hashCode());
    protected static final int LEVEL1_VARIABLES = 1;
    protected Outline outline;
    protected AbstractDataViewPageBook pagebook;
    TreeViewer viewer;

    public AbstractDataViewPage(IDocumentProvider listerDocumentProvider, ListerEditor listerEditor, int pgmlang) {
        this();
        this.editor = listerEditor;
        this.outline = listerEditor.getOutline();
        this.debugitem = debug.getResource(this.editor.getResource());
        this.session = (debugSession)debug.getResource((IResource)this.editor.getResource().getProject());
        this.debugfile = this.session.getFile(this.editor.getResource());
        this.lang = pgmlang;
    }

    protected AbstractDataViewPage() {
    }

    public void checkRefresh(ArrayList<MemoryUpdateTable> updateTable) {
        for (MemoryUpdateTable tab : updateTable) {
            if (!tab.getSuccessFlag()) continue;
            this.debugitem.firePropertyChangeListeners(new PropertyChangeEvent((Object)tab, "MEMORY_UPDATE", null, (Object)tab));
        }
    }

    protected abstract ViewData getcontentProvider();

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68356);
        Tree tree = this.viewer.getTree();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        TreeViewerFocusCellManager mgr = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        String[] labels = AbstractDataViewPageBook.labels;
        int[] styles = AbstractDataViewPageBook.styles;
        int columnIndex = 0;
        while (columnIndex < labels.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new VariableColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new BasicEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new ValueEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new HexValueColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new HexValueEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 3: {
                    column.setLabelProvider((CellLabelProvider)new PropertyColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new BasicEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                }
            }
            column.getColumn().setText(labels[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData("column_width", (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(true);
            column.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    Tree table;
                    if (AbstractDataViewPage.this.viewer != null && !(table = AbstractDataViewPage.this.viewer.getTree()).isDisposed()) {
                        AbstractDataViewPage.this.pagebook.setOrder(table.getColumnOrder());
                    }
                }

                public void controlResized(ControlEvent e) {
                    TreeColumn column = (TreeColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData("column_width");
                        AbstractDataViewPage.this.pagebook.getWidth()[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++columnIndex;
        }
        tree.setFont(JFaceResources.getTextFont());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)this.getcontentProvider());
        this.viewer.setColumnProperties(labels);
        this.control = this.viewer.getControl();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.activateContext();
    }

    protected void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (this.session.isBatch()) {
            contextService.activateContext("com.ca.intertest.context.batch");
        } else {
            contextService.activateContext("com.ca.intertest.context.cics");
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Control getControl() {
        return this.control;
    }

    public Outline getOutline() {
        return this.outline;
    }

    public AbstractDataViewPageBook getPagebook() {
        return this.pagebook;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void reSize() {
        if (this.isViewerControlAvailable()) {
            Tree tr = this.viewer.getTree();
            tr.setColumnOrder(this.pagebook.getOrder());
            TreeColumn[] treeColumnArray = tr.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                Integer colid = (Integer)column.getData("column_width");
                column.setWidth(this.pagebook.getWidth()[colid]);
                ++n2;
            }
        }
    }

    protected boolean isViewerControlAvailable() {
        if (this.viewer == null) {
            return false;
        }
        if (this.viewer.getControl() == null) {
            return false;
        }
        return !this.viewer.getControl().isDisposed();
    }

    public boolean addObject(TreeObject item) {
        if (!this.keptObjects.contains(item)) {
            return this.keptObjects.add(item);
        }
        return false;
    }

    public void setFocus() {
        if (this.control != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(new Object[0]));
            this.control.setFocus();
        }
    }

    public void setPagebook(AbstractDataViewPageBook pagebook) {
        this.pagebook = pagebook;
    }

    protected boolean ApplyUpdate(MemoryUpdateTable tab, MFAddress startAddr, int lth, TreeObject treeobject) {
        MFAddress addrz = startAddr.add((long)lth);
        MFAddress celladdr = tab.getCelladdr();
        String hexcell = tab.getHexcell();
        if (celladdr.compareTo(startAddr) > 0 || addrz.compareTo(celladdr) > 0) {
            return false;
        }
        byte[] ebytes = new byte[hexcell.length() / 2];
        HexUtil.HextoBytes((String)hexcell, (byte[])ebytes);
        ByteBuffer bb = treeobject.getBackingdata();
        int offset = (int)celladdr.subtract(startAddr);
        ((Buffer)bb).position(offset);
        bb.put(ebytes);
        treeobject.setBackingdata(bb);
        return true;
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        String[] contextIDs = this.getContextList();
        if (contextIDs == null || contextIDs.length == 0) {
            contextIDs = new String[]{this.getViewID()};
        }
        String[] stringArray = contextIDs;
        int n = contextIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            menuMgr.add((IContributionItem)new GroupMarker(item));
            ++n2;
        }
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.control);
        this.control.setMenu(menu);
        IPageSite site = this.getSite();
        String[] stringArray2 = contextIDs;
        int n3 = contextIDs.length;
        int n4 = 0;
        while (n4 < n3) {
            String item = stringArray2[n4];
            site.registerContextMenu(item, menuMgr, (ISelectionProvider)this.viewer);
            ++n4;
        }
    }

    protected abstract String getViewID();

    protected abstract String[] getContextList();

    protected void hookDoubleClickAction() {
        ChangeKeepItemAction change = new ChangeKeepItemAction();
        change.init((IPage)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)change);
    }

    public ListerEditor getEditor() {
        return this.editor;
    }

    public int getLang() {
        return this.lang;
    }

    public debugSession getSession() {
        return this.session;
    }

    public IDebug getDebugitem() {
        return this.debugitem;
    }

    public void dispose() {
        if (this.viewer != null) {
            IContentProvider provider = this.viewer.getContentProvider();
            if (provider != null) {
                provider.dispose();
            }
            this.viewer.getControl().dispose();
        }
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    public boolean isBackTraceStop() {
        return this.session.isBackTraceStop(this.debugfile);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

