/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.breakpoint;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.actions.ConfigureBPPropertiesAction;
import com.ca.intertest.ui.actions.ConfigureBreakpointAction;
import com.ca.intertest.ui.actions.GlobalBreakpointAction;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.breakpoint.BreakpointPageBook;
import com.ca.intertest.ui.views.breakpoint.Breakpointlabelprovider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;

public class BreakpointPage
extends Page
implements IPageBookViewPage,
IAdaptable {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final Image warningimage;
    private TableViewer viewer;
    private GlobalBreakpointAction action;
    private Object input;
    private ListerEditor editor = null;
    private Debug debug = Debug.getInstance();
    private debugSession debugsession;
    private PropertyListener listener;
    private debugFile debugfile;
    private Table table;
    public static final DecimalFormat stmtformat;
    private BreakpointPageBook pagebook;
    private Control control;

    static {
        ImageDescriptor newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("WARNING_ICON");
        warningimage = newimage != null ? newimage.createImage(true) : null;
        stmtformat = new DecimalFormat("000000");
    }

    public BreakpointPage(ListerEditor listerEditor) {
        if (listerEditor != null) {
            this.editor = listerEditor;
        }
    }

    public void createControl(Composite parent) {
        this.debugfile = (debugFile)this.debug.getResource(this.editor.getResource());
        this.listener = new PropertyListener();
        this.debugsession = this.debugfile.getSession();
        this.debugsession.getStore().addPropertyChangeListener(this.listener);
        this.table = new Table(parent, 66306);
        Listener sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                if (BreakpointPage.this.table.getSortColumn() == column) {
                    switch (BreakpointPage.this.table.getSortDirection()) {
                        case 128: {
                            BreakpointPage.this.table.setSortDirection(1024);
                            break;
                        }
                        case 1024: {
                            BreakpointPage.this.table.setSortDirection(0);
                            column = null;
                            break;
                        }
                        default: {
                            BreakpointPage.this.table.setSortDirection(128);
                            break;
                        }
                    }
                } else {
                    BreakpointPage.this.table.setSortColumn(column);
                    BreakpointPage.this.table.setSortDirection(128);
                }
                BreakpointPage.this.pagebook.setSortdirection(BreakpointPage.this.table.getSortDirection());
                BreakpointPage.this.pagebook.setSortcolumn(column == null ? -1 : (Integer)column.getData());
                BreakpointPage.this.viewer.refresh();
            }
        };
        this.viewer = new TableViewer(this.table);
        int i = 0;
        while (i < BreakpointPageBook.labels.length) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, BreakpointPageBook.styles[i]);
            column.getColumn().setText(BreakpointPageBook.labels[i]);
            column.getColumn().setMoveable(true);
            column.getColumn().setResizable(true);
            column.getColumn().setData((Object)new Integer(i));
            column.getColumn().addListener(13, sortListener);
            column.setLabelProvider((CellLabelProvider)new Breakpointlabelprovider(i, this.debugfile, this.editor));
            column.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    Table table;
                    if (BreakpointPage.this.viewer != null && !(table = BreakpointPage.this.viewer.getTable()).isDisposed()) {
                        BreakpointPage.this.pagebook.setOrder(table.getColumnOrder());
                    }
                }

                public void controlResized(ControlEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData();
                        if (BreakpointPage.this.debugsession.isBatch() && (id == 5 || id == 4)) {
                            return;
                        }
                        ((BreakpointPage)BreakpointPage.this).pagebook.getWidth()[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.control = this.viewer.getControl();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setSorter((ViewerSorter)new ViewSorter());
        this.hookContextMenu();
        this.hookDoubleClickAction();
        if (this.input == null) {
            this.viewer.setInput((Object)this.editor.getResource());
        } else {
            this.viewer.setInput(this.input);
        }
        this.reSize();
        this.debugsession.addPropertyChangeListener(this.listener);
        this.debugfile.addPropertyChangeListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void dispose() {
        if (this.listener != null && this.debugsession != null) {
            this.debugsession.getStore().removePropertyChangeListener(this.listener);
            this.debugsession.removePropertyChangeListener(this.listener);
            this.debugfile.removePropertyChangeListener(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return BreakpointPage.this.editor;
                }
            };
        }
        return null;
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        if (this.control != null) {
            this.control.setFocus();
            this.viewer.setSelection(new ISelection(){

                public boolean isEmpty() {
                    return true;
                }
            });
        }
    }

    public void setInput(Object editorInput) {
        this.input = editorInput;
        if (this.viewer != null) {
            this.viewer.setInput(this.input);
        }
    }

    public void reSize() {
        if (this.table != null && !this.table.isDisposed()) {
            TableColumn column;
            this.table.setColumnOrder(this.pagebook.getOrder());
            Object[] objectArray = this.table.getColumns();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                column = objectArray[n2];
                Integer colid = (Integer)column.getData();
                column.setWidth(this.pagebook.getWidth()[colid]);
                ++n2;
            }
            if (this.debugsession.isBatch()) {
                int[] nArray = new int[]{5, 4};
                objectArray = nArray;
                n = nArray.length;
                n2 = 0;
                while (n2 < n) {
                    TableColumn index = objectArray[n2];
                    this.table.getColumn((int)index).setWidth(0);
                    ++n2;
                }
            }
            column = null;
            try {
                column = this.table.getColumn(this.pagebook.getSortcolumn());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            int direction = this.pagebook.getSortdirection();
            if (this.table.getSortColumn() != column) {
                this.table.setSortColumn(column);
                this.table.setSortDirection(direction);
                this.viewer.refresh();
            } else if (direction != this.table.getSortDirection()) {
                this.table.setSortDirection(direction);
                this.viewer.refresh();
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("com.ca.intertest.ui.views.breakpoint"));
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.control);
        this.control.setMenu(menu);
        this.getSite().registerContextMenu("com.ca.intertest.ui.views.breakpoint", menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        ConfigureBPPropertiesAction listener = new ConfigureBPPropertiesAction();
        listener.init(this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)listener);
        ConfigureBreakpointAction configlistener = new ConfigureBreakpointAction();
        configlistener.init(this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)configlistener);
    }

    public BreakpointPageBook getPagebook() {
        return this.pagebook;
    }

    public ListerEditor getEditor() {
        return this.editor;
    }

    public void setPagebook(BreakpointPageBook pagebook, GlobalBreakpointAction action) {
        this.pagebook = pagebook;
        this.action = action;
    }

    public static Image getWarningimage() {
        return warningimage;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.action);
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Control control;
            boolean go = false;
            String property = event.getProperty();
            IMarker marker = null;
            Object oldvalue = event.getOldValue();
            Object newvalue = event.getNewValue();
            if (property.equals("com.ca.intertest.breakpoint.rbp")) {
                go = true;
            } else if (property.equals("userid") || property.equals("termid")) {
                go = true;
            } else {
                Object source = event.getSource();
                if (source instanceof debugFile && BreakpointPage.this.debugfile.equals(source)) {
                    marker = null;
                    go = true;
                } else if (source instanceof BreakpointMarker) {
                    marker = ((BreakpointMarker)source).getMarker();
                    if (!BreakpointPage.this.debugfile.getResource().equals((Object)marker.getResource())) {
                        return;
                    }
                    go = true;
                } else {
                    return;
                }
                if (oldvalue != null && oldvalue.equals(newvalue) && oldvalue instanceof IMarker) {
                    marker = (IMarker)oldvalue;
                    if (!marker.getAttribute("BREAKPOINT_ENABLED", true)) {
                        marker = null;
                        go = true;
                    }
                } else {
                    marker = null;
                }
            }
            if ((go || marker != null) && !(control = BreakpointPage.this.viewer.getControl()).isDisposed()) {
                control.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        BreakpointPage.this.viewer.refresh();
                    }
                });
            }
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] elements = new Object[]{};
            IResource res = null;
            if (parent != null && (elements = parent instanceof Object[] ? (Object[])parent : new Object[]{parent}).length > 0) {
                if (elements[0] instanceof IResource) {
                    res = (IResource)elements[0];
                } else if (elements[0] instanceof IDebugMarker) {
                    res = ((IDebugMarker)elements[0]).getResource();
                }
            }
            if (res == null || !res.exists()) {
                elements = new Object[]{};
                return elements;
            }
            ArrayList<IMarker> objects = new ArrayList<IMarker>();
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = res.findMarkers("com.ca.intertest.breakpoint", true, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker element = iMarkerArray[n2];
                    boolean enabled = element.getAttribute("BREAKPOINT_ENABLED", false);
                    if (enabled) {
                        objects.add(element);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            return objects.toArray();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                v.refresh();
            }
        }
    }

    public class ViewSorter
    extends ViewerSorter {
        public boolean isSorterProperty(Object element, String property) {
            return super.isSorterProperty(element, property);
        }

        public int category(Object element) {
            if (element instanceof IT_TreeItem && ((IT_TreeItem)element).getType() == TreeType.MARKER) {
                element = ((IT_TreeItem)element).getObj();
            }
            if (element instanceof IMarker) {
                IMarker marker;
                block6: {
                    marker = (IMarker)element;
                    try {
                        if (marker.isSubtypeOf("com.ca.intertest.breakpoint")) break block6;
                        return -1;
                    }
                    catch (CoreException coreException) {}
                }
                String type = marker.getType();
                if (type.equals("com.ca.intertest.breakpoint.rbp")) {
                    return 1;
                }
                return 6;
            }
            return -1;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int e2i;
            int e1i;
            int cat2;
            String c2;
            int colid;
            Breakpointlabelprovider provider;
            String c1;
            int result;
            if (e1 instanceof IT_TreeItem && ((IT_TreeItem)e1).getType() == TreeType.MARKER) {
                e1 = ((IT_TreeItem)e1).getObj();
            }
            if (e2 instanceof IT_TreeItem && ((IT_TreeItem)e2).getType() == TreeType.MARKER) {
                e2 = ((IT_TreeItem)e2).getObj();
            }
            Table table = ((TableViewer)viewer).getTable();
            TableColumn column = table.getSortColumn();
            int direction = table.getSortDirection();
            if (direction != 0 && column != null && (result = (c1 = (provider = (Breakpointlabelprovider)((TableViewer)viewer).getLabelProvider(colid = ((Integer)column.getData()).intValue())).getText(e1)).compareTo(c2 = provider.getText(e2))) != 0) {
                return direction == 128 ? result : 0 - result;
            }
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof IMarker && e2 instanceof IMarker && (e1i = ((IMarker)e1).getAttribute("stmtNumber", 0)) != (e2i = ((IMarker)e2).getAttribute("stmtNumber", 0))) {
                return e1i - e2i;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

