/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.backtrace;

import com.ca.intertest.common.Messages;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.ProjectPageBookView;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class BacktracePageBook
extends ProjectPageBookView {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final int TRACE_PROGRAM = 0;
    public static final int TRACE_STATEMENT = 1;
    public static final int TRACE_TEXT = 2;
    private static final String COL_ORDER = "column_order";
    private static final String COL_WIDTH = "column_width";
    private static final String COL_COUNT = "column_count";
    static final String[] labels = new String[]{Messages.BacktracePageBook_3, Messages.BacktracePageBook_4, Messages.BacktracePageBook_5};
    static final int[] styles = new int[]{131072, 16384, 16384};
    static final int[] Column_width = new int[]{12, 6, 40};
    private int[] order;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.statementtraceview";

    public BacktracePageBook() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.order = nArray;
    }

    @Override
    protected Page doCreateProjectPage(IWorkbenchPart part, IProject project) {
        this.checkWidth();
        BacktracePage page = (BacktracePage)part.getAdapter(BacktracePage.class);
        if (page != null) {
            this.initPage(page);
            page.setPagebook(this);
            page.createControl((Composite)this.getPageBook());
            return page;
        }
        return null;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.setMessage(Messages.BacktracePageBook_no_info);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), CONTEXT_HELP_ID);
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        IPage obj = pageRec.page;
        if (obj instanceof BacktracePage) {
            ((BacktracePage)obj).reSize();
        }
    }

    @Override
    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    @Override
    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ListerEditor;
    }

    public int[] getOrder() {
        return this.order;
    }

    public void setOrder(int[] order) {
        this.order = order;
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer count = memento.getInteger(COL_COUNT);
            if (count == null) {
                count = labels.length;
            }
            if (count == labels.length) {
                int i;
                String colstring = memento.getString(COL_ORDER);
                if (colstring != null) {
                    String[] colorder = colstring.split(";");
                    this.order = new int[colorder.length];
                    i = 0;
                    while (i < colorder.length) {
                        this.order[i] = Integer.parseInt(colorder[i]);
                        ++i;
                    }
                }
                if ((colstring = memento.getString(COL_WIDTH)) != null) {
                    String[] colwidth = colstring.split(";");
                    this.width = new int[colwidth.length];
                    i = 0;
                    while (i < colwidth.length) {
                        this.width[i] = Integer.parseInt(colwidth[i]);
                        ++i;
                    }
                }
            }
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        memento.putInteger(COL_COUNT, this.order.length);
        StringBuilder colstring = new StringBuilder();
        int[] nArray = this.order;
        int n = this.order.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            colstring.append(String.format("%d;", item));
            ++n2;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_ORDER, colstring.toString());
        colstring = new StringBuilder();
        if (this.width != null) {
            nArray = this.width;
            n = this.width.length;
            n2 = 0;
            while (n2 < n) {
                int col = nArray[n2];
                colstring.append(String.format("%d;", col));
                ++n2;
            }
            colstring.setLength(colstring.length() - 1);
            memento.putString(COL_WIDTH, colstring.toString());
        }
        super.saveState(memento);
    }

    public void setContentDescription(String description) {
        super.setContentDescription(description);
    }

    @Override
    protected int[] getColumn_Width() {
        return Column_width;
    }

    @Override
    protected void refreshPage(Page page) {
        TableViewer viewer;
        if (page != null && (viewer = ((BacktracePage)page).getViewer()) != null) {
            if (viewer.getContentProvider() == null) {
                page.createControl((Composite)this.getPageBook());
                viewer = ((BacktracePage)page).getViewer();
            }
            viewer.setInput((Object)page);
        }
    }
}

