/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.util;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Messages;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.util.IWordProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class ReservedWordProvider
implements IWordProvider {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private HashMap<String, Object> cobolWords = new HashMap();
    private HashMap<String, Object> asmMachWords = new HashMap();
    private HashMap<String, Object> asmWords = new HashMap();
    private HashMap<String, Object> pliWords = new HashMap();

    public ReservedWordProvider() throws ITException {
        XMLMemento memento = null;
        String[] str = null;
        Bundle bundle = null;
        URL urlEntry = null;
        InputStreamReader urlReader = null;
        InputStream urlStream = null;
        try {
            bundle = IntertestPlugin.getDefault().getBundle();
            if (bundle == null) {
                throw new ITException(Messages.ReservedWordProvider_0);
            }
            urlEntry = bundle.getEntry("reservedwords.xml");
            if (urlEntry == null) {
                throw new ITException(Messages.ReservedWordProvider_2);
            }
            urlStream = urlEntry.openStream();
            if (urlStream == null) {
                throw new ITException(Messages.ReservedWordProvider_3);
            }
        }
        catch (IOException iOException) {
            throw new ITException(Messages.ReservedWordProvider_4);
        }
        urlReader = new InputStreamReader(urlStream);
        if (urlReader == null) {
            throw new ITException(Messages.ReservedWordProvider_5);
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)urlReader);
        }
        catch (WorkbenchException workbenchException) {
            throw new ITException(Messages.ReservedWordProvider_6);
        }
        str = memento.getChild("COBOL").getString("words").split(",");
        int i = 0;
        while (i < str.length) {
            this.cobolWords.put(str[i].trim(), null);
            ++i;
        }
        str = null;
        str = memento.getChild("ASM_MACHINE").getString("words").split(",");
        i = 0;
        while (i < str.length) {
            this.asmWords.put(str[i].trim(), null);
            ++i;
        }
        str = null;
        str = memento.getChild("ASSEMBLER").getString("words").split(",");
        i = 0;
        while (i < str.length) {
            this.asmWords.put(str[i].trim(), null);
            ++i;
        }
        str = null;
        str = memento.getChild("PLI").getString("words").split(",");
        i = 0;
        while (i < str.length) {
            this.pliWords.put(str[i].trim(), null);
            ++i;
        }
    }

    @Override
    public boolean containsWord(String word, int wordGroup) {
        boolean b = false;
        switch (wordGroup) {
            case 1: {
                if (!this.cobolWords.containsKey(word)) break;
                b = true;
                break;
            }
            case 10: {
                if (!this.asmWords.containsKey(word)) break;
                b = true;
                break;
            }
            case 11: {
                if (!this.asmMachWords.containsKey(word)) break;
                b = true;
                break;
            }
            case 15: {
                if (!this.pliWords.containsKey(word)) break;
                b = true;
                break;
            }
            default: {
                b = false;
            }
        }
        return b;
    }
}

