/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.asm;

import com.ca.intertest.common.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class AsmDoubleClickStrategy
implements ITextDoubleClickStrategy {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private ITextViewer tviewer;
    private IDocument doc;
    private IRegion line;
    private int selection;
    private int start;
    private int end;

    public void doubleClicked(ITextViewer viewer) {
        this.tviewer = viewer;
        this.doc = this.tviewer.getDocument();
        this.selection = this.tviewer.getSelectedRange().x;
        try {
            this.line = this.doc.getLineInformationOfOffset(this.selection);
        }
        catch (BadLocationException e) {
            Logger.loggit(e);
        }
        if (this.selection < 0) {
            return;
        }
        this.selectText();
    }

    protected boolean findText() {
        int position = this.selection;
        char atSign = '@';
        char poundSign = '#';
        char dollarSign = '$';
        char underscore = '_';
        try {
            char c;
            while (position >= 0) {
                c = this.doc.getChar(position);
                if (!Character.isLetterOrDigit(c) && c != underscore && c != atSign && c != poundSign && c != dollarSign) break;
                --position;
            }
            this.start = position;
            position = this.selection;
            int length = this.line.getOffset() + this.line.getLength();
            while (position < length) {
                c = this.doc.getChar(position);
                if (!Character.isLetterOrDigit(c) && c != underscore && c != atSign && c != poundSign && c != dollarSign) break;
                ++position;
            }
            this.end = position;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void selectText() {
        if (this.findText()) {
            if (this.start == this.end) {
                this.tviewer.setSelectedRange(this.start, 0);
            } else {
                this.tviewer.setSelectedRange(this.start + 1, this.end - this.start - 1);
            }
        }
    }
}

