/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IViewConnector;
import com.ca.intertest.common.XMLTraceUtils;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.LoadTraceDialog;
import com.ca.intertest.ui.actions.AbstractDebuggingAction;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class LoadTraceDataAction
extends AbstractDebuggingAction
implements IViewConnector {
    private IViewPart insideView;
    private Shell shell;
    private TreeViewer viewer;
    public IStructuredSelection dummySelection;
    private static Debug debug = Debug.getInstance();

    public void loadTraceData() {
        this.shell = this.insideView.getViewSite().getShell();
        LoadTraceDialog dialog = new LoadTraceDialog(this.shell);
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        Object[] selectedTrace = dialog.getResult();
        if (selectedTrace[0] instanceof IFile) {
            IFile fileResource = (IFile)selectedTrace[0];
            this.session = debug.getSession((IResource)fileResource);
            String programName = XMLTraceUtils.loadTraceData(fileResource.getLocation().toString(), this.session);
            debug.openListerEditor(programName, this.session);
            debug.notifyViewForRefresh(this.session);
        }
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        this.insideView = view;
        if (view instanceof PageBookView) {
            this.book = (PageBookView)view;
        } else {
            this.viewer = null;
        }
        debug.addItemToViewsList(this);
    }

    @Override
    public void run(IAction action) {
        IPage page;
        this.loadTraceData();
        debug.setLoadTraceAction(this);
        if (this.book != null && (page = this.book.getCurrentPage()) instanceof BacktracePage) {
            BacktracePage bppage = (BacktracePage)page;
            bppage.refreshViewer();
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public debugSession getSession() {
        return this.session;
    }

    @Override
    public void refresh(debugSession session) {
        IPage page;
        this.session = session;
        if (this.book != null && (page = this.book.getCurrentPage()) instanceof BacktracePage) {
            BacktracePage bppage = (BacktracePage)page;
            bppage.refreshViewer();
        }
    }
}

