/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.dialogs.PLIPointerDialog;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.outline.OutlinePage;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class KeepSelectAction
implements IEditorActionDelegate,
IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    static final String NULL_STRING = "";
    private ListerEditor editor;
    private ArrayList<String> namelist = new ArrayList();
    private ArrayList<TreeObject> treelist = new ArrayList();
    private IResource resource = null;
    private Outline outline = null;
    protected PageBookView book = null;
    private boolean isBased = false;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ListerEditor ? (ListerEditor)targetEditor : null;
        this.resource = null;
    }

    private boolean isFiller(String token) {
        return this.outline != null && this.outline.getLanguage() == 32 && "FILLER".equalsIgnoreCase(token);
    }

    public void run(IAction action) {
        if (this.namelist.size() == 0) {
            return;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.resource.findMarkers("com.ca.intertest.keep", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String name = (String)marker.getAttribute("name");
                String altname = (String)marker.getAttribute("altname");
                int index = this.namelist.indexOf(name);
                if (index >= 0 && altname.length() == 0) {
                    this.namelist.remove(index);
                    if (this.namelist.size() == 0) {
                        return;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e1) {
            Logger.loggit(e1);
        }
        this.checkInit();
        if (this.resource != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int ptr = 0;
                    for (String item : KeepSelectAction.this.namelist) {
                        TreeObject tree = (TreeObject)KeepSelectAction.this.treelist.get(ptr);
                        ++ptr;
                        String altname = KeepSelectAction.this.checkPLIBased(tree);
                        if (KeepSelectAction.this.isBased && altname.length() <= 0) continue;
                        try {
                            IMarker marker = KeepSelectAction.this.resource.createMarker("com.ca.intertest.keep");
                            if (marker == null || !marker.exists()) continue;
                            marker.setAttribute("altname", (Object)altname);
                            marker.setAttribute("name", (Object)item);
                            marker.setAttribute("keeptype", (Object)"DATAVIEW_VARFIABLE");
                        }
                        catch (CoreException coreException) {}
                    }
                }
            };
            try {
                this.resource.getWorkspace().run(r, (ISchedulingRule)this.resource, 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        this.checkInit();
        this.namelist.clear();
        this.treelist.clear();
        if (this.editor != null) {
            TextSelection sel;
            String key;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel2 = (IStructuredSelection)selection;
                Object[] objectArray = sel2.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TreeObject) {
                        String name;
                        TreeObject treeobject = (TreeObject)object;
                        if (treeobject.getType() == 1 && !this.isFiller(treeobject.getName()) && !this.namelist.contains(name = this.outline.getQualifiedName(treeobject))) {
                            this.namelist.add(name);
                            this.treelist.add(treeobject);
                        }
                    } else {
                        String key2 = this.fixKey(object.toString());
                        TreeObject[] treeObjectArray = this.outline.getQualifiedObjects(key2);
                        int n3 = treeObjectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeObject item = treeObjectArray[n4];
                            String name = this.outline.getQualifiedName(item);
                            if (!this.namelist.contains(name)) {
                                this.namelist.add(name);
                                this.treelist.add(item);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else if (selection instanceof TextSelection && (key = this.fixKey((sel = (TextSelection)selection).getText())).length() > 0 && !this.isFiller(key) && this.outline != null) {
                Integer statement = this.editor.getOutline().getLineXref().get(sel.getStartLine() + 1);
                if (statement == null) {
                    statement = -1;
                }
                String stmtKey = String.format("%06d:%s", statement, key);
                TreeObject[] treeObjectArray = this.outline.getQualifiedObjects(stmtKey);
                int n = treeObjectArray.length;
                int n5 = 0;
                while (n5 < n) {
                    String name;
                    TreeObject item = treeObjectArray[n5];
                    if (item.getType() == 1 && !this.namelist.contains(name = this.outline.getQualifiedName(item))) {
                        this.namelist.add(name);
                        this.treelist.add(item);
                    }
                    ++n5;
                }
            }
            enabled = this.namelist.size() > 0;
        }
        action.setEnabled(enabled);
    }

    private String fixKey(String key) {
        if (key == null) {
            return NULL_STRING;
        }
        if (this.outline != null && this.outline.getLanguage() != 128) {
            return key.trim().toUpperCase();
        }
        return key.trim();
    }

    private void checkInit() {
        if (this.book != null) {
            IPage page = this.book.getCurrentPage();
            if (page instanceof AbstractDataViewPage) {
                AbstractDataViewPage keeppage = (AbstractDataViewPage)page;
                this.editor = keeppage.getEditor();
                this.resource = this.editor.getResource();
                this.outline = this.editor.getOutline();
            } else if (page instanceof OutlinePage) {
                OutlinePage outlinepage = (OutlinePage)page;
                this.editor = outlinepage.getEditor();
                this.resource = this.editor.getResource();
                this.outline = this.editor.getOutline();
            }
        } else if (this.editor != null) {
            this.resource = this.editor.getResource();
            this.outline = this.editor.getOutline();
        }
    }

    public void init(IViewPart view) {
        if (view instanceof PageBookView) {
            this.book = (PageBookView)view;
        }
    }

    public String checkPLIBased(TreeObject tree) {
        this.isBased = false;
        String altname = NULL_STRING;
        if (this.outline.getLanguage() != 128) {
            return NULL_STRING;
        }
        int hpvltp = Integer.parseInt((String)Attribute.getValue("gt_pvltp", tree), 16);
        if ((hpvltp & 4) != 0) {
            this.isBased = false;
            return NULL_STRING;
        }
        if ((Integer)Attribute.getValue("gt_dstyp", tree) == 6) {
            this.isBased = true;
            PLIPointerDialog dialog = new PLIPointerDialog(this.editor.getSite().getShell());
            dialog.init(this.outline.getPLIPointerObjects(), tree);
            dialog.open();
            altname = dialog.getPLIPointer();
            if (altname.length() == 0) {
                String errMsg = String.format(Messages.KeepSelectAction_errMsg, tree.getName());
                MessageDialog.openWarning(null, (String)Messages.KeepSelectAction_title, (String)errMsg);
                return altname;
            }
            String sub = dialog.getSubscripts();
            if (sub.length() > 0) {
                altname = String.valueOf(altname) + "(" + sub + ")";
            }
            altname = String.valueOf(altname) + "->" + tree.getName();
        }
        return altname;
    }
}

