/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DeleteAction
implements IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private IStructuredSelection selection;
    IViewPart view;

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        String question = null;
        if (this.selection.size() > 1) {
            question = String.format(Messages.DeleteAction_0, this.selection.size());
        } else {
            Object obj = this.selection.getFirstElement();
            if (obj instanceof IT_TreeItem) {
                Object treeitem = ((IT_TreeItem)obj).getObj();
                if (treeitem instanceof debugSession) {
                    question = String.format(Messages.DeleteAction_1, ((debugSession)treeitem).getName());
                } else if (treeitem instanceof debugFile) {
                    question = String.format(Messages.DeleteAction_2, ((debugFile)treeitem).getName());
                }
            } else if (obj instanceof ServerElement) {
                question = String.format(Messages.ServerView_delete_obj, obj.toString());
            }
        }
        if (question == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)this.view.getSite().getShell(), (String)Messages.DeleteAction_3, (String)question)) {
            return;
        }
        for (Object obj : this.selection.toList()) {
            if (obj instanceof IT_TreeItem) {
                Object treeitem = ((IT_TreeItem)obj).getObj();
                if (treeitem instanceof debugSession) {
                    Debug.getInstance().removeDebugSession((debugSession)treeitem);
                    continue;
                }
                if (!(treeitem instanceof debugFile)) continue;
                debugSession session = ((debugFile)treeitem).getSession();
                session.deleteDebugfile((debugFile)treeitem);
                continue;
            }
            if (!(obj instanceof ServerElement)) continue;
            ServerList.getInstance().removeServerElement((ServerElement)obj);
        }
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean enabled = !sel.isEmpty();
        for (Object obj : sel.toList()) {
            if (obj instanceof IT_TreeItem) {
                if ((obj = ((IT_TreeItem)obj).getObj()) instanceof IDebug) {
                    boolean disable;
                    IDebug debugit = (IDebug)obj;
                    debugSession session = debugit.getSession();
                    boolean bl = disable = session == null ? false : session.isDebugging();
                    if (disable && debugit instanceof debugFile) {
                        disable = ((debugFile)debugit).isMonitor();
                    }
                    if (!disable) continue;
                    enabled = false;
                    break;
                }
                enabled = false;
                break;
            }
            if (obj instanceof ServerElement) continue;
            enabled = false;
            break;
        }
        this.selection = enabled ? sel : null;
        action.setEnabled(enabled);
    }
}

