/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.RegisterViewData;
import com.ca.intertest.ui.views.data.RegisterViewPage;
import com.ca.intertest.ui.views.data.RegisterViewPageBook;
import com.ca.intertest.wizards.CoreWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;

public class CoreRegisterItemAction
implements IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String BATCH_REQUEST = "R%1$d";
    private static final String CICS_REQUEST = "%%R%1$d";
    private RegisterViewPageBook book = null;
    private RegisterViewPage page = null;
    private debugFile debugitem;
    private ListerEditor editor;
    private TreeObject treeobject;

    public void init(IPage page) {
        if (page instanceof RegisterViewPage) {
            this.page = (RegisterViewPage)page;
            this.debugitem = (debugFile)this.page.getDebugitem();
            this.editor = this.page.getEditor();
        } else {
            page = null;
            this.debugitem = null;
            this.editor = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof RegisterViewPageBook) {
            this.book = (RegisterViewPageBook)view;
        }
    }

    public void run(IAction action) {
        int index;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (this.page == null || !this.page.getSession().isAtBreakpoint() || !this.debugitem.isMonitor()) {
            action.setEnabled(false);
            return;
        }
        try {
            index = this.page.getViewer().getColumnViewerEditor().getFocusCell().getColumnIndex();
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        String regstring = "";
        int rowindex = -1;
        if (index-- > 0 && (this.debugitem.getSession().isCICS() || this.debugitem.getLanguage() == 16)) {
            if (this.treeobject != null) {
                String rowname = this.treeobject.getName();
                int realChildnameLen = this.treeobject.getParent().getName().equals("VREG") || rowname.equals("VREG") ? RegisterViewData.childname.length : 4;
                int ix = 0;
                while (ix < realChildnameLen) {
                    if (RegisterViewData.childname[ix].equals(rowname)) {
                        rowindex = ix;
                        break;
                    }
                    ++ix;
                }
            }
            if (rowindex != -1) {
                int register = index + rowindex * 4;
                String format = this.debugitem.getSession().isCICS() ? CICS_REQUEST : BATCH_REQUEST;
                regstring = String.format(format, register);
            }
        }
        CoreWizard wizard = new CoreWizard();
        wizard.initCmd(this.editor, regstring, false);
        MemoryWizardDialog dialog = new MemoryWizardDialog(this.page.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.treeobject = null;
        if (selection == null) {
            action.setEnabled(false);
            return;
        }
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (this.page != null && this.debugitem != null && this.page.getSession().isAtBreakpoint() && this.debugitem.isMonitor()) {
            Object obj;
            IStructuredSelection sel;
            if ((this.debugitem.getSession().isCICS() || this.debugitem.getLanguage() == 16) && (sel = (IStructuredSelection)selection).size() == 1 && (obj = sel.getFirstElement()) instanceof TreeObject) {
                String parentname;
                this.treeobject = (TreeObject)obj;
                TreeObject parent = this.treeobject.getParent();
                String string = parentname = parent == null ? this.treeobject.getName() : parent.getName();
                if (!"REGS".equals(parentname) && !"REGS64".equals(parentname)) {
                    this.treeobject = null;
                }
            }
            enabled = true;
        }
        action.setEnabled(enabled);
    }
}

