/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.dialogs.DataViewArrayDialog;
import com.ca.intertest.dialogs.DataViewValueDialog;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AutoDataViewPage;
import com.ca.intertest.wizards.CoreWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class ChangeKeepItemAction
implements IViewActionDelegate,
IDoubleClickListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected final int maxlength = IntertestPlugin.getConfigurationPreferences().getInt("DATAVIEW_MAXLENGTH");
    private PageBookView book = null;
    private AbstractDataViewPage page = null;
    protected Object object = null;
    protected IDebug debugitem;

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        this.run(null);
    }

    public void init(IPage page) {
        if (page instanceof AbstractDataViewPage) {
            this.page = (AbstractDataViewPage)page;
            this.debugitem = this.page.getDebugitem();
        } else {
            page = null;
            this.debugitem = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof PageBookView) {
            this.book = (PageBookView)view;
        }
    }

    public void run(IAction action) {
        if (this.object instanceof TreeObject) {
            if (this.book != null) {
                this.init(this.book.getCurrentPage());
            }
            if (this.page != null && !this.page.isBackTraceStop()) {
                TreeObject treeobject = (TreeObject)this.object;
                boolean expression = "CORE_EXPRESSION".equals(treeobject.getAttribute("dataflag"));
                boolean keyword = "DATAVIEW_KEYWORD".equals(treeobject.getAttribute("dataflag"));
                if (!expression && treeobject.getType() != 1) {
                    return;
                }
                int length = (Integer)Attribute.getValue("length", treeobject);
                Shell shell = this.page.getSite().getShell();
                int dmax1 = (Integer)Attribute.getValue("gt_dmax1", treeobject);
                boolean groupVar = this.checkChildren(treeobject);
                if (length > this.maxlength || expression || groupVar) {
                    int stmt = 0;
                    if (!keyword) {
                        stmt = (Integer)Attribute.getValue("statementnumber", treeobject);
                    }
                    CoreWizard wizard = new CoreWizard();
                    if (expression) {
                        wizard.initCmd(this.page.getEditor(), treeobject.getAlternateName(), false);
                    } else {
                        if (treeobject.getBackingdata() == null) {
                            String str = String.valueOf(Messages.ChangeKeepItemAction_3) + treeobject.getName();
                            MessageDialog.openInformation((Shell)this.page.getSite().getShell(), (String)Messages.ChangeKeepItemAction_4, (String)str);
                            return;
                        }
                        wizard.initVar(this.page.getEditor(), treeobject, stmt);
                    }
                    MemoryWizardDialog dialog = new MemoryWizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                } else {
                    boolean postedOccurrence;
                    boolean autodata = this.page instanceof AutoDataViewPage;
                    boolean bl = postedOccurrence = treeobject.getAttribute("arraycell").length() > 0;
                    if (dmax1 > 0 && !autodata && !postedOccurrence) {
                        DataViewArrayDialog dlgDVArray = new DataViewArrayDialog(this.page.getSite().getShell());
                        dlgDVArray.init((Variable)treeobject, this.page);
                        dlgDVArray.open();
                    } else {
                        DataViewValueDialog dlgDVValue = new DataViewValueDialog(shell);
                        MFAddress addr = treeobject.getAddress();
                        if (addr.equals((Object)MFAddress.ZERO_ADDR)) {
                            int offset = (Integer)Attribute.getValue("structureoffset", treeobject);
                            int parentoffset = (Integer)Attribute.getValue("structureoffset", treeobject.getParent());
                            treeobject.setAddress(addr.add((long)(offset - parentoffset)));
                        }
                        if (treeobject.getBackingdata() == null) {
                            String str = String.valueOf(Messages.ChangeKeepItemAction_6) + treeobject.getName();
                            MessageDialog.openInformation((Shell)this.page.getSite().getShell(), (String)Messages.ChangeKeepItemAction_7, (String)str);
                            return;
                        }
                        dlgDVValue.init((Variable)treeobject, this.page.getSession());
                        dlgDVValue.open();
                    }
                }
                if (!expression) {
                    this.page.reSize();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeObject treeobject;
        Object obj;
        IStructuredSelection sel;
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        this.object = null;
        if (this.page != null && this.page.getSession().isAtBreakpoint() && (sel = (IStructuredSelection)selection).size() == 1 && (obj = sel.getFirstElement()) instanceof TreeObject && ((treeobject = (TreeObject)obj).getAttribute("dataflag").equals("CORE_EXPRESSION") || treeobject instanceof Variable)) {
            enabled = true;
            this.object = treeobject;
        }
        if (enabled && !(this.debugitem instanceof debugFile)) {
            enabled = false;
            this.object = null;
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public boolean checkChildren(TreeObject treeobject) {
        if (treeobject.allChildrenAreIndex()) {
            return false;
        }
        return treeobject.hasChildren();
    }
}

