/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Messages;
import com.ca.intertest.server.IWebSocketClient;
import com.ca.intertest.server.IntertestWebSocketClient;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.ITException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.tyrus.client.ClientManager;

public class WebSocketManager {
    private static WebSocketManager instance;
    ClientManager clientManager = ClientManager.createClient();
    private CountDownLatch messageLatch;

    private WebSocketManager() {
    }

    public static synchronized WebSocketManager getManager() {
        if (instance == null) {
            instance = new WebSocketManager();
        }
        return instance;
    }

    public synchronized IntertestWebSocketClient connect(IWebSocketClient client, ServerElement server) throws Exception {
        this.messageLatch = new CountDownLatch(1);
        int timeout = ServerList.getInstance().getConnecttime();
        boolean connected = true;
        String socketProtocol = "WS";
        if (server.getProtocol().equalsIgnoreCase("HTTPS")) {
            socketProtocol = "WSS";
        }
        URI endpointURI = new URI(String.valueOf(socketProtocol.toLowerCase()) + "://" + server.getHostname() + ":" + server.getPort() + "/intertest/websocket");
        IntertestWebSocketClient wsClient = new IntertestWebSocketClient(this.messageLatch, client, server);
        this.clientManager.connectToServer((Object)wsClient, endpointURI);
        if (timeout == 0) {
            try {
                this.messageLatch.await();
            }
            catch (InterruptedException interruptedException) {
                connected = false;
            }
        } else {
            connected = this.messageLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        if (!connected) {
            String errorMessage = String.format(Messages.Connection_3, server.getHostname(), server.getPort());
            throw new ITException(errorMessage);
        }
        wsClient.setIntertestClient(client);
        return wsClient;
    }

    protected void finalize() throws Throwable {
        this.clientManager.shutdown();
        super.finalize();
    }
}

