/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.IWebSocketClient;
import com.ca.intertest.server.IntertestWebSocketClient;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.WebSocketManager;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITSecurityException;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;

public class WSConnection
extends Connection
implements IWebSocketClient {
    private IntertestWebSocketClient client;

    protected WSConnection(ServerElement server) {
        super(server);
    }

    @Override
    public boolean connect(boolean logon) throws Exception {
        this.initStatus();
        if (!this.connected) {
            try {
                WebSocketManager wsManager = WebSocketManager.getManager();
                this.client = wsManager.connect(this, this.server);
                if (logon && !this.loggedin) {
                    this.login();
                }
                this.connected = true;
            }
            catch (UnresolvedAddressException unresolvedAddressException) {
                this.errorLevel = 16;
                this.errorMessage = String.format(Messages.Connection_4, this.server.getHostname(), this.server.getPort(), this.errorMessage);
                throw new ITException(this.errorMessage);
            }
            catch (ConnectException connectException) {
                this.errorLevel = 16;
                this.errorMessage = String.format(Messages.Connection_2, this.server.getHostname(), this.server.getPort(), this.errorMessage);
                throw new ITException(this.errorMessage);
            }
            catch (Exception e) {
                this.errorLevel = 4;
                String error = HexUtil.getErrorText((Throwable)e);
                this.errorMessage = String.format(Messages.Connection_5, this.server.getHostname(), this.server.getPort(), error);
                throw e;
            }
        }
        return this.connected;
    }

    @Override
    public int disconnect() {
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                this.errorLevel = 32;
                this.errorMessage = HexUtil.getErrorText((Throwable)e);
            }
        }
        this.connected = false;
        this.loggedin = false;
        return this.errorLevel;
    }

    public CVMO process(CVMI cvmi) {
        CVMO cvmo;
        int result = 0;
        try {
            result = this.login();
        }
        catch (ITSecurityException e) {
            Logger.loggit(e);
            this.showSecurityFailure(e);
        }
        if (result == 0) {
            cvmo = this.processRaw(cvmi);
            if (cvmi.size() > 0 && cvmo.size() == 0) {
                cvmo.addMessage((DebugMessage)new StatusMessage(4, Messages.Connection_8));
            }
        } else {
            StatusMessage msg = result == 4 ? new StatusMessage((short)result, Messages.Connection_9) : new StatusMessage((short)this.errorLevel, this.errorMessage);
            cvmo = new CVMO();
            cvmo.addMessage((DebugMessage)msg);
            WSConnection.processStatusMessages(cvmi, cvmo);
        }
        this.errorLevel = cvmo.getErrorLevel();
        this.errorMessage = cvmo.getErrorMessage();
        this.errorCount = cvmo.getErrorCount();
        return cvmo;
    }

    protected synchronized CVMO processRaw(CVMI cvmi) {
        CVMO cvmo = new CVMO();
        this.errorCount = 0;
        this.errorLevel = 0;
        this.errorMessage = Messages.Connection_6;
        try {
            try {
                cvmo = this.client.processBlocking(cvmi);
            }
            catch (ITException e) {
                Logger.loggit(e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, String.valueOf(Messages.Connection_11) + HexUtil.getErrorText((Throwable)e)));
                WSConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
            catch (Exception e) {
                Logger.loggit(e);
                this.connected = false;
                cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                WSConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
        }
        finally {
            WSConnection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }

    public CVMO processSubmitJob(CVMI cvmi) {
        this.client.setMessagetrap();
        CVMO cvmo = this.processRaw(cvmi);
        return cvmo;
    }

    @Override
    public void setClient(IntertestWebSocketClient client) {
        this.client = client;
    }

    public debugSession getDebugSession() {
        return this.session;
    }

    public void setDebugSession(debugSession session) {
        this.session = session;
    }

    protected void finalize() throws Throwable {
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClient() {
        IntertestWebSocketClient intertestWebSocketClient = this.client;
        synchronized (intertestWebSocketClient) {
            this.client.notifyAll();
        }
    }
}

