/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.SynchSymbolic2;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.server.BatchConnection;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.IWebSocketClient;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.server.WSConnection;
import com.ca.intertest.server.WebSocketManager;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.InitMessage;
import com.ca.intertest.tools.MoreMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

@ClientEndpoint
public class IntertestWebSocketClient {
    private CountDownLatch messageLatch;
    private IWebSocketClient intertestClient;
    private Session wsSession;
    private ServerElement server;
    private CVMO resultCVMO;
    private Exception resultException;
    private int messageTrap;

    public IntertestWebSocketClient(CountDownLatch messageLatch, IWebSocketClient client, ServerElement server) {
        this.messageLatch = messageLatch;
        this.intertestClient = client;
        this.server = server;
        this.messageTrap = 1;
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        this.wsSession = session;
        this.intertestClient.setClient(this);
        this.messageLatch.countDown();
    }

    @OnClose
    public synchronized void onClose(Session userSession, CloseReason reason) {
        if (this.intertestClient instanceof WSConnection) {
            WSConnection conn = (WSConnection)this.intertestClient;
            conn.disconnect();
            return;
        }
        if (this.intertestClient instanceof DebugTalker) {
            DebugTalker talker = (DebugTalker)this.intertestClient;
            talker.Shutdown();
        }
        this.notifyAll();
    }

    @OnError
    public synchronized void onError(Throwable t) throws Throwable {
        this.resultException = new Exception(t);
        this.notifyAll();
    }

    @OnMessage
    public synchronized void onMessage(InputStream message) {
        try {
            this.resultCVMO = this.ReadIn(message);
            DebugTalker talker = this.checkTalker(this.resultCVMO);
            if (talker != null) {
                ThreadGroup threads = new ThreadGroup("intertest");
                Thread thread = new Thread(threads, talker);
                if (thread != null) {
                    thread.start();
                }
            } else {
                this.notifyAll();
            }
        }
        catch (Exception e) {
            this.resultException = e;
        }
    }

    public synchronized CVMO processBlocking(CVMI cvmi) throws ITException, IOException, Exception {
        return this.process(cvmi, true);
    }

    public synchronized void processNonBlocking(CVMI cvmi) throws ITException, IOException, Exception {
        this.process(cvmi, false);
    }

    private CVMO process(CVMI cvmi, boolean shouldWait) throws ITException, IOException, Exception {
        block9: {
            this.resultCVMO = new CVMO();
            try {
                try {
                    this.WriteOut(cvmi);
                    if (shouldWait) {
                        int requestCount = this.messageTrap;
                        while (this.messageTrap > 0) {
                            this.wait(ServerList.getInstance().getResponsetime());
                            --this.messageTrap;
                        }
                        if (this.resultCVMO.size() < requestCount) {
                            this.resultCVMO.addMessage((DebugMessage)new StatusMessage(32, Messages.DebugSessionSetup_7));
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.messageTrap = 1;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.messageTrap = 1;
                throw throwable;
            }
            this.messageTrap = 1;
        }
        if (this.resultException != null) {
            throw this.resultException;
        }
        return this.resultCVMO;
    }

    private DebugTalker checkTalker(CVMO cvmo) throws IOException, Exception {
        DebugTalker talker = null;
        DebugMessage lastMessage = cvmo.getLastMessage();
        if (lastMessage.getMessageID() == 26 && lastMessage.getSubmessageID() == 4) {
            InitMessage initMessage = (InitMessage)lastMessage;
            int eventId = initMessage.getSessionID();
            CVMI cvmi = new CVMI();
            InitMessage cvmiInitMessage = new InitMessage();
            debugSession debugSession2 = null;
            if (this.intertestClient instanceof CICSConnection) {
                CICSConnection connection = (CICSConnection)this.intertestClient;
                debugSession2 = connection.getDebugSession();
            }
            try {
                cvmiInitMessage.setSubmessageID((short)5);
                cvmiInitMessage.setSessionID(eventId);
                cvmi.addMessage((DebugMessage)cvmiInitMessage);
                WebSocketManager wsManager = WebSocketManager.getManager();
                talker = new DebugTalker(debugSession2);
                IntertestWebSocketClient talkerClient = wsManager.connect(talker, this.server);
                talker.setClient(talkerClient);
                CVMO breakpointCVMO = talker.process(cvmi);
                talker.setBreakpointCVMO(breakpointCVMO);
                return talker;
            }
            catch (Exception e) {
                Logger.loggit(e);
                IT_ErrorDialog.openError(32, Messages.IntertestWSClient_DebugTalker_Title, Messages.IntertestWSClient_DebugTalker_Text, (Throwable)e);
                return null;
            }
        }
        if (this.intertestClient instanceof BatchConnection) {
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                final DebugMessage dbgMessage = debugMessageArray[n2];
                if (dbgMessage instanceof BreakMessage) {
                    BatchConnection connection = (BatchConnection)this.intertestClient;
                    debugSession dbgSession = connection.getDebugSession();
                    if (dbgMessage.getMessageID() == 1 && dbgSession.getTalker() == null) {
                        dbgSession.setUID(((BreakMessage)dbgMessage).getSessionID());
                        CVMO bpCVMO = cvmo;
                        bpCVMO.deleteStatusMessage();
                        talker = new DebugTalker(dbgSession);
                        talker.setClient(this);
                        talker.setBreakpointCVMO(bpCVMO);
                    }
                }
                if (dbgMessage instanceof SynchronizeMessage) {
                    CompletableFuture.runAsync(new Runnable(){

                        @Override
                        public void run() {
                            WSConnection connection = (WSConnection)IntertestWebSocketClient.this.intertestClient;
                            debugSession dbgSession = connection.getDebugSession();
                            try {
                                SynchSymbolic2 synch = new SynchSymbolic2((SynchronizeMessage)dbgMessage, dbgSession, null);
                                CVMI synchFileCVMI = synch.synchronizeFile();
                                connection.process(synchFileCVMI);
                            }
                            catch (ITException e) {
                                Logger.loggit(e);
                            }
                        }
                    });
                }
                ++n2;
            }
        }
        return talker;
    }

    protected CVMO ReadIn(InputStream input) throws ITException, Exception {
        DataInputStream instream = new DataInputStream(input);
        CVMO cvmo = new CVMO();
        if (this.messageTrap == 1) {
            cvmo = this.resultCVMO;
        }
        if (!this.wsSession.isOpen()) {
            return null;
        }
        byte[] buffer = null;
        ByteBuffer bytebuffer = null;
        boolean morepackets = true;
        int bufflen = 0;
        Logger.loggit(0, Messages.Connection_0);
        while (morepackets) {
            bufflen = instream.readInt();
            if (bufflen <= 4) continue;
            int toread = bufflen - 4;
            try {
                buffer = new byte[bufflen];
                int pos = 4;
                instream.readFully(buffer, pos, toread);
                bytebuffer = ByteBuffer.wrap(buffer).putInt(0, bufflen);
                Logger.logPacket(buffer, CVMO.class, new Throwable(), this.wsSession.getId());
                cvmo.setArray(bytebuffer, false);
                morepackets = cvmo.getLastMessage() instanceof MoreMessage;
            }
            catch (VirtualMachineError e) {
                Logger.loggit(e);
                cvmo.addMessage((DebugMessage)new StatusMessage(32, Messages.Connection_BadPacket));
                morepackets = false;
            }
        }
        Logger.DisplayPacket((DSECT)cvmo, new Throwable());
        return cvmo;
    }

    private void WriteOut(CVMI cvmi) throws ITException, IOException, Exception {
        if (!this.wsSession.isOpen()) {
            throw new ITException(Messages.IntertestWebSocketClient_1);
        }
        if (this.intertestClient instanceof Connection) {
            Logger.DisplayPacket((DSECT)cvmi, new Throwable());
        }
        byte[] bytes = cvmi.getArray();
        this.sendBinary(bytes);
        Logger.logPacket(bytes, CVMI.class, new Throwable(), this.wsSession.getId());
    }

    private void sendBinary(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.wsSession.getBasicRemote().sendBinary(buffer);
    }

    public boolean isConnected() {
        if (this.wsSession == null) {
            return false;
        }
        return this.wsSession.isOpen();
    }

    public void disconnect() throws IOException {
        if (this.wsSession != null) {
            this.wsSession.close();
        }
    }

    public String getSessionId() {
        if (this.wsSession != null) {
            return this.wsSession.getId();
        }
        return null;
    }

    public void setTimeout(int timeout) {
        if (this.wsSession != null) {
            this.wsSession.setMaxIdleTimeout((long)timeout);
        }
    }

    public void setIntertestClient(IWebSocketClient intertestClient) {
        this.intertestClient = intertestClient;
    }

    public Session getWsSession() {
        return this.wsSession;
    }

    public void setMessagetrap() {
        this.messageTrap = 2;
    }
}

