/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.Command;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileAccessMessage;
import com.ca.intertest.tools.FileGetMessage;
import com.ca.intertest.tools.FileNameExtended;
import com.ca.intertest.tools.FilePutMessage;
import com.ca.intertest.tools.FileReceiveMessage;
import com.ca.intertest.tools.GDSNMessage;
import com.ca.intertest.tools.GMBRMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MemberInfo;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.http.entity.ByteArrayEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FileConnection
extends Connection {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private XMLRequest xml;

    public FileConnection(ServerElement server) {
        super(server);
    }

    public CVMO getMembers(String DSN) {
        CVMI cvmi = new CVMI();
        GDSNMessage msg = new GDSNMessage();
        msg.setDSName(DSN);
        cvmi.addMessage((DebugMessage)msg);
        CVMO cvmo = this.processTomcat(true, new HashMap<String, Object>(), cvmi);
        return cvmo;
    }

    public CVMO getFile(FileNameExtended file) {
        if (file.getDSN().length() == 0) {
            return this.setError(file.getMemberName());
        }
        CVMI cvmi = new CVMI();
        FileGetMessage msg = new FileGetMessage(file);
        cvmi.addMessage((DebugMessage)msg);
        CVMO cvmo = this.doTomcatDownload(cvmi);
        return cvmo;
    }

    private CVMO doTomcatDownload(CVMI cvmi) {
        String apacheServerName = this.server.getName();
        TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
        ServerConnect connect = new ServerConnect(apacheServer, "intertest/server");
        CVMO cvmo = new CVMO();
        try {
            try {
                ByteArrayEntity entity = null;
                if (cvmi != null && cvmi.size() > 0) {
                    byte[] data = cvmi.getArray();
                    entity = new ByteArrayEntity(data);
                    entity.setContentType("application/vnd.ca.intertest.dsect");
                }
                Map map = ((FileGetMessage)cvmi.getLastMessage()).getFile().getParms();
                XMLRequest xml = connect.connect(Command.getfile.toString(), map, true, false, (Object)entity);
                this.errorLevel = xml.getErrorLevel();
                this.errorMessage = xml.getErrorMessage();
                if (this.errorLevel != 0) {
                    this.errorCount = 1;
                    cvmo.addMessage((DebugMessage)new StatusMessage((short)this.errorLevel, this.errorMessage));
                } else {
                    File file = xml.getAttachedFile();
                    if (file == null) {
                        cvmo.addMessage((DebugMessage)new StatusMessage(16, "No File received from server"));
                    } else {
                        FileNameExtended filename = new FileNameExtended(this.getParms(xml));
                        FileReceiveMessage receivemsg = new FileReceiveMessage(filename);
                        receivemsg.setFilesize(file.length());
                        cvmo.addMessage((DebugMessage)receivemsg);
                        receivemsg.isStream();
                        receivemsg.setInputstream((InputStream)new FileInputStream(file));
                    }
                }
            }
            catch (ITException e) {
                cvmo = new CVMO();
                this.log.log(Level.WARNING, "", e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, HexUtil.getErrorText((Throwable)e)));
                FileConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
            catch (Exception e) {
                cvmo = new CVMO();
                this.log.log(Level.WARNING, "", e);
                this.connected = false;
                cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                FileConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
        }
        finally {
            FileConnection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }

    private Map<String, Object> getParms(XMLRequest xml) {
        Element command = xml.getCommand();
        NamedNodeMap parms = command.getAttributes();
        int size = parms.getLength();
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        int ix = 0;
        while (ix < size) {
            Node item = parms.item(ix);
            map.put(item.getNodeName(), item.getNodeValue());
            ++ix;
        }
        return map;
    }

    public CVMO putFile(FileNameExtended file) {
        CVMI cvmi = new CVMI();
        CVMO cvmo = null;
        FilePutMessage msg = new FilePutMessage(file);
        cvmi.addMessage((DebugMessage)msg);
        cvmo = this.doTomcatUpload(cvmi);
        return cvmo;
    }

    private CVMO doTomcatUpload(CVMI cvmi) {
        String apacheServerName = this.server.getName();
        TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
        ServerConnect connect = new ServerConnect(apacheServer, "intertest/server");
        CVMO cvmo = new CVMO();
        FilePutMessage message = (FilePutMessage)cvmi.getMessage(1);
        try {
            try {
                File tempfile = File.createTempFile("CAIT", ".upload");
                tempfile.deleteOnExit();
                BufferedReader reader = new BufferedReader(new InputStreamReader(message.getInputstream()));
                FileOutputStream fileout = new FileOutputStream(tempfile);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fileout));
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
                writer.close();
                reader.close();
                this.deleteFile((FileAccessMessage)message);
                Map map = ((FilePutMessage)cvmi.getLastMessage()).getFile().getParms();
                XMLRequest xml = connect.connect(Command.putfile.toString(), map, true, false, (Object)tempfile);
                this.errorLevel = xml.getErrorLevel();
                this.errorMessage = xml.getErrorMessage();
                if (this.errorLevel != 0) {
                    this.errorCount = 1;
                    cvmo.addMessage((DebugMessage)new StatusMessage((short)this.errorLevel, this.errorMessage));
                }
            }
            catch (Exception e) {
                cvmo = new CVMO();
                this.log.log(Level.WARNING, "", e);
                this.connected = false;
                cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                FileConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
        }
        finally {
            FileConnection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }

    public CVMO getfile(Member member) {
        if (member.getDsn().length() == 0) {
            return this.setError(member.getName());
        }
        CVMI cvmi = new CVMI();
        GMBRMessage getmember = new GMBRMessage();
        try {
            getmember.setSubmessageID((short)1);
        }
        catch (ITException iTException) {}
        MemberInfo info = new MemberInfo(member.getAttributes());
        info.setMember(member.getName());
        info.setDate(member.getDate());
        info.setTime(member.getTime());
        getmember.setMemberinfo(info);
        getmember.setDSN(member.getDsn());
        getmember.setSelectedDate(member.getSelectedDate());
        getmember.setSelectedTime(member.getSelectedTime());
        cvmi.addMessage((DebugMessage)getmember);
        CVMO cvmo = this.processTomcat(true, new HashMap<String, Object>(), cvmi);
        return cvmo;
    }

    private CVMO setError(String string) {
        CVMO cvmo = new CVMO();
        String text = String.format(Messages.FileConnection_5, string);
        StatusMessage status = new StatusMessage(16, text);
        cvmo.addMessage((DebugMessage)status);
        StatusMessage.logStatus(status, null, (Exception)((Object)new ITException()));
        this.setErrorLevel(status.getStatus());
        this.setErrorMessage(text);
        return cvmo;
    }

    public void deleteFile(FileAccessMessage file) {
        Object obj;
        if (file.isDelete() && (obj = file.getObject()) instanceof File) {
            ((File)obj).delete();
        }
    }

    public CVMO processTomcat(boolean doSignon, Map<String, Object> map, CVMI cvmi) {
        CVMO cvmo;
        block14: {
            boolean hasCvmi;
            String apacheServerName = this.server.getName();
            TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
            ServerConnect connect = new ServerConnect(apacheServer, "intertest/server");
            cvmo = null;
            boolean bl = hasCvmi = cvmi != null && cvmi.size() > 0;
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            try {
                ByteArrayEntity entity;
                if (hasCvmi) {
                    byte[] data = cvmi.getArray();
                    entity = new ByteArrayEntity(data);
                    this.log.log(Level.FINE, "CVMI", (Object)data);
                    entity.setContentType("application/vnd.ca.intertest.dsect");
                } else {
                    entity = null;
                }
                this.xml = connect.connect(Command.passthru.toString(), map, doSignon, false, (Object)entity);
                this.errorLevel = this.xml.getErrorLevel();
                this.errorMessage = this.xml.getErrorMessage();
                if (this.errorLevel != 0) {
                    this.errorCount = 1;
                    cvmo = new CVMO();
                    cvmo.addMessage((DebugMessage)new StatusMessage((short)this.errorLevel, this.errorMessage));
                } else {
                    File file = this.xml.getAttachedFile();
                    if (file == null) {
                        cvmo = new CVMO();
                        if (hasCvmi) {
                            cvmo.addMessage((DebugMessage)new StatusMessage(16, "No CVMO received from server"));
                            this.xml.setStatus(16, "No CVMO received from server");
                        }
                    } else {
                        FileInputStream stream = new FileInputStream(file);
                        byte[] buffer = new byte[(int)file.length()];
                        stream.read(buffer);
                        stream.close();
                        file.delete();
                        this.log.log(Level.FINE, "CVMO", (Object)buffer);
                        cvmo = new CVMO(ByteBuffer.wrap(buffer));
                    }
                }
            }
            catch (ITException e) {
                cvmo = new CVMO();
                this.log.log(Level.WARNING, "", e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, HexUtil.getErrorText((Throwable)e)));
                FileConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
                break block14;
            }
            catch (Exception e) {
                try {
                    cvmo = new CVMO();
                    this.log.log(Level.WARNING, "", e);
                    this.connected = false;
                    cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                }
                catch (Throwable throwable) {
                    FileConnection.processStatusMessages(cvmi, cvmo);
                    this.errorLevel = cvmo.getErrorLevel();
                    this.errorMessage = cvmo.getErrorMessage();
                    this.errorCount = cvmo.getErrorCount();
                    throw throwable;
                }
                FileConnection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
                break block14;
            }
            FileConnection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }

    @Override
    public boolean connect(boolean logon) throws Exception {
        this.initStatus();
        if (!this.connected) {
            try {
                if (logon && !this.loggedin) {
                    this.login();
                }
                this.connected = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.connected;
    }
}

