/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITSecurityException;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.ValidateCredentials;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public abstract class Connection {
    private static final int LOOP_COUNT = 1;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected static com.ca.intertest.common.Logger staticlog = com.ca.intertest.common.Logger.getLogger(Connection.class.getName());
    static final String cacopyright = "Copyright ? 2017 CA";
    protected boolean loggedin = false;
    protected boolean connected = false;
    protected String userid;
    protected String password;
    public ServerElement server = null;
    protected int errorLevel;
    protected int errorCount;
    protected String errorMessage = null;
    protected debugSession session;

    protected Connection(ServerElement server) {
        Assert.isNotNull((Object)server, (String)Messages.Connection_2);
        this.server = server;
    }

    abstract boolean connect(boolean var1) throws ITException, Exception;

    public boolean isConnected() {
        return this.connected;
    }

    protected void initStatus() {
        this.errorLevel = 0;
        this.errorMessage = Messages.Connection_6;
    }

    protected int login() throws ITSecurityException {
        if (this.loggedin) {
            return 0;
        }
        int loop = 1;
        while (loop <= 1) {
            CVMO cvmo = new CVMO();
            CVMI cvmi = new CVMI();
            try {
                this.userid = this.server.getLogonUser();
                this.password = this.server.getPassword();
            }
            catch (ITException iTException) {
                return 4;
            }
            cvmi.addMessage((DebugMessage)new SignonMessage(this.userid, this.password));
            TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(this.server.name);
            apacheServer.setPassword(this.password);
            ValidateCredentials validate = new ValidateCredentials(apacheServer);
            this.errorLevel = validate.run(true);
            if (this.errorLevel == 0) {
                this.loggedin = true;
                loop = 1;
                apacheServer.setUser(this.userid);
                apacheServer.setUserDialog(true);
            } else {
                this.server.resetUserDialog();
                if (loop != 1) {
                    Connection.displayError(cvmo, Messages.Connection_7);
                }
            }
            ++loop;
        }
        if (this.errorLevel != 0) {
            throw new ITSecurityException(this.errorMessage);
        }
        return this.errorLevel;
    }

    public static void processStatusMessages(CVMI cvmi, CVMO cvmo) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            if (message.getMessageID() == 18) {
                IStatusMessage status = (IStatusMessage)message;
                short statuscode = status.getStatus();
                if (statuscode > 0) {
                    DebugMessage cvmimessage;
                    DebugMessage debugMessage = cvmimessage = cvmi == null ? null : cvmi.getMessage(status.getRequestseqno());
                    if (cvmimessage != null) {
                        String name;
                        String action = cvmimessage.getClass().getSimpleName().replace(Messages.Connection_14, "");
                        FileType filetype = cvmimessage.getFiletype();
                        switch (filetype) {
                            case TERMID: 
                            case TRANID: {
                                name = cvmimessage.getShortProgram();
                                break;
                            }
                            default: {
                                name = cvmimessage.getProgram();
                            }
                        }
                        String format = name == null || name.length() == 0 ? Messages.Connection_16 : Messages.Connection_17;
                        String text = String.format(format, action, filetype.toString(), name, statuscode, status.getMessage(0));
                        com.ca.intertest.common.Logger.loggit((int)statuscode, text);
                    }
                }
                StatusMessage.logStatus(status, null, (Exception)((Object)new ITException()));
            }
            ++n2;
        }
    }

    protected void showSecurityFailure(final ITSecurityException e) {
        final Display display = Display.getDefault();
        if (display != null) {
            IntertestPlugin.startErrorLog();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IT_ErrorDialog.openError(display.getActiveShell(), Messages.Connection_18, HexUtil.getErrorText((Throwable)e), (Throwable)e);
                }
            });
        }
    }

    public static void displayError(CVMO cvmo, String title) {
        if (cvmo.getErrorCount() > 0) {
            final String titletext = title == null ? Messages.Connection_19 : title;
            final int count = cvmo.getErrorCount();
            final int error = cvmo.getErrorLevel();
            Display display = Display.getDefault();
            if (display != null) {
                IntertestPlugin.startErrorLog();
                final String text = cvmo.getErrorMessage();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String format;
                        String word;
                        String string = word = error > 4 ? Messages.Connection_20 : Messages.Connection_21;
                        if (count == 1) {
                            format = String.valueOf(Messages.Connection_22) + IConstants.LINEFEED + Messages.Connection_23;
                        } else {
                            format = Messages.Connection_24;
                            format = String.valueOf(format) + IConstants.LINEFEED + Messages.Connection_25;
                        }
                        if (error > 4) {
                            MessageDialog.openError(null, (String)titletext, (String)String.format(format, count, text, word));
                        } else {
                            MessageDialog.openWarning(null, (String)titletext, (String)String.format(format, count, text, word));
                        }
                    }
                });
            }
        }
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorText() {
        String msg = String.valueOf(Messages.Connection_27) + Integer.toString(this.errorLevel) + " " + this.errorMessage;
        return msg;
    }

    public synchronized ServerElement getServer() {
        return this.server;
    }

    protected final void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    protected final void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    protected void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public boolean isLoggedIn() {
        return this.loggedin;
    }

    public int disconnect() {
        this.connected = false;
        this.loggedin = false;
        return this.errorLevel;
    }
}

