/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.SynchSymbolic2;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.WSConnection;
import com.ca.intertest.tools.CSect;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GetCompositeMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.tools.TerminateSessionMessage;
import java.util.ArrayList;

public class CICSConnection
extends WSConnection {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private debugFile file;
    private ArrayList<String> monitorNames = null;

    public CICSConnection(ServerElement server, debugSession session) {
        super(server);
        this.session = session;
    }

    public debugFile getFile() {
        return this.file;
    }

    public void setFile(debugFile file) {
        this.file = file;
    }

    @Override
    protected CVMO processRaw(CVMI cvmi) {
        CVMO cvmo = super.processRaw(cvmi);
        if (cvmo.size() == 1) {
            try {
                DebugMessage msg = cvmo.getMessage(1);
                if (msg instanceof SynchronizeMessage) {
                    SynchSymbolic2 synch = this.monitorNames != null && this.monitorNames.contains(((SynchronizeMessage)msg).getProgram()) || this.monitorNames == null ? new SynchSymbolic2((SynchronizeMessage)msg, this.session, this.file) : new SynchSymbolic2((SynchronizeMessage)msg, this.session, this.file, false);
                    return this.process(synch.synchronizeFile());
                }
            }
            catch (ITException e) {
                Logger.loggit(e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, HexUtil.getErrorText((Throwable)e)));
            }
        }
        return cvmo;
    }

    public CVMO processComposite(CVMI cvmi) {
        if (this.monitorNames == null) {
            this.monitorNames = new ArrayList(((GetCompositeMessage)cvmi.getLastMessage()).getCSects().size());
        } else {
            this.monitorNames.clear();
            this.monitorNames.ensureCapacity(((GetCompositeMessage)cvmi.getLastMessage()).getCSects().size());
        }
        for (CSect cs : ((GetCompositeMessage)cvmi.getLastMessage()).getCSects()) {
            if (cs.getComment().length() != 0) continue;
            this.monitorNames.add(cs.getMonitorName());
        }
        return this.process(cvmi);
    }

    public void resetMonitorNames() {
        this.monitorNames = null;
    }

    public void terminateCICSSession() {
        CVMI cvmi = new CVMI();
        TerminateSessionMessage terminateMessage = new TerminateSessionMessage();
        cvmi.addMessage((DebugMessage)terminateMessage);
        this.process(cvmi);
    }
}

