/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserLogon
extends IntertestDialog
implements Listener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String CHECK_HERE = Messages.UserLogon_0;
    private static final String ENTER_PASSWORD = Messages.UserLogon_1;
    private static final String ENTER_USER_NAME = Messages.UserLogon_2;
    private Text userid;
    private final ServerElement server;
    private Text password;
    private Button savepswd;
    private Text message;

    public UserLogon(Shell parentShell, ServerElement server) {
        super(parentShell);
        this.server = server;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        int width;
        Point extent;
        this.CONTEXT_ID = "serverWizardPageOld";
        Shell shell = this.getShell();
        shell.setText(Messages.UserLogon_4);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(composite, 1);
        label.setText(this.server.getName());
        GridData data = new GridData(32);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        GC gc = new GC((Drawable)label);
        Point point = gc.stringExtent(this.server.getName());
        data.minimumWidth = point.x;
        data.widthHint = point.x;
        gc.dispose();
        label = new Label(composite, 0);
        label.setText(Messages.UserLogon_5);
        this.userid = new Text(composite, 2048);
        data = new GridData();
        gc = new GC((Drawable)this.userid);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 8 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.userid.setLayoutData((Object)data);
        this.userid.setText(this.server.getUser());
        label = new Label(composite, 0);
        label.setText(Messages.UserLogon_6);
        this.password = new Text(composite, 0x400800);
        data = new GridData();
        gc = new GC((Drawable)this.password);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 8 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.password.setLayoutData((Object)data);
        if (this.server.isSavepassword()) {
            this.password.setText(this.server.getPassword());
        } else {
            this.password.setText("");
        }
        this.savepswd = new Button(composite, 32);
        this.savepswd.setSelection(this.server.isSavepassword());
        this.savepswd.setText(Messages.UserLogon_8);
        data = new GridData();
        data.horizontalSpan = 2;
        this.savepswd.setLayoutData((Object)data);
        this.userid.addListener(24, (Listener)this);
        this.password.addListener(24, (Listener)this);
        this.savepswd.addListener(24, (Listener)this);
        Label sText = new Label(composite, 72);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = 30 * extent.x;
        sText.setLayoutData((Object)data);
        sText.setText(CHECK_HERE);
        if (this.userid.getText().length() == 0) {
            this.userid.setFocus();
        } else {
            this.password.setFocus();
        }
        this.message = new Text(composite, 9);
        this.message.setText(ENTER_USER_NAME);
        data = new GridData(32);
        data.horizontalSpan = 2;
        this.message.setLayoutData((Object)data);
        gc = new GC((Drawable)this.message);
        point = gc.stringExtent(ENTER_USER_NAME);
        Point point2 = gc.stringExtent(ENTER_PASSWORD);
        data.minimumWidth = width = Math.max(point.x, point2.x);
        data.widthHint = width;
        gc.dispose();
        return composite;
    }

    public void handleEvent(Event event) {
        this.checkButtons();
    }

    private void checkButtons() {
        boolean ok = true;
        String text = "";
        if ("".equals(this.userid.getText().trim())) {
            text = ENTER_USER_NAME;
            ok = false;
        } else if ("".equals(this.password.getText().trim())) {
            text = ENTER_PASSWORD;
            ok = false;
        }
        this.message.setText(text);
        this.getButton(0).setEnabled(ok);
    }

    protected void okPressed() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "password", (Object)"oldvalue", (Object)"newvalue");
        this.server.setPassword(this.password.getText().trim());
        this.server.setUser(this.userid.getText().trim());
        this.server.setSavepassword(this.savepswd.getSelection());
        ServerList.getInstance().firePropertyChangeListeners(event);
        super.okPressed();
    }

    public void create() {
        super.create();
        this.checkButtons();
    }
}

