/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDSN;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.dialogs.MRUCombo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SchedulingDatasetDialog
extends IntertestDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String EMPTY = "";
    private String process = "";
    private String member = "";
    private String dsn = "";
    private String filetype = "P";
    private MRUCombo SourceDSN;
    private MRUCombo SourceMember;
    private Button pdsRadioButton;
    private Button seqRadioButton;
    private boolean isPDS = true;

    public SchedulingDatasetDialog(Shell parentShell) {
        super(parentShell);
    }

    public SchedulingDatasetDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(Messages.SchedulingDatasetDialog_5) + this.process + Messages.SchedulingDatasetDialog_6);
    }

    public void init(String dsn, String member, String filetype, String process) {
        this.CONTEXT_ID = "schedulingPage";
        this.dsn = dsn;
        this.member = member;
        if (filetype != null && filetype.length() == 1) {
            this.filetype = filetype;
        }
        this.process = process;
        this.isPDS = this.filetype.equals("P");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.createDSNGroup(composite);
        if (this.isPDS) {
            this.SourceMember.getCombo().setEnabled(true);
        } else {
            this.SourceMember.getCombo().setEnabled(false);
        }
        return composite;
    }

    private void createDSNGroup(Composite parent) {
        Group source = new Group(parent, 16);
        source.setLayout((Layout)new GridLayout(4, true));
        source.setText(String.valueOf(Messages.SchedulingDatasetDialog_9) + this.process);
        Label DSNLabel = new Label((Composite)source, 0);
        DSNLabel.setText("DSN");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        DSNLabel.setLayoutData((Object)gridData);
        this.SourceDSN = new MRUCombo((Composite)source, 4, "SOURCE");
        this.SourceDSN.getCombo().setTextLimit(44);
        Combo combo = this.SourceDSN.getCombo();
        TextUtil.setWidth(combo, 20, 44);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        String name = this.dsn;
        int index = name == null ? -1 : combo.indexOf(name);
        combo.select(index);
        gridData = new GridData(32);
        gridData.horizontalSpan = 3;
        combo.setLayoutData((Object)gridData);
        Label MemberLabel = new Label((Composite)source, 0);
        MemberLabel.setText(Messages.SchedulingDatasetDialog_11);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        MemberLabel.setLayoutData((Object)gridData);
        this.SourceMember = new MRUCombo((Composite)source, 4, "Name");
        this.SourceMember.getCombo().setTextLimit(8);
        combo = this.SourceMember.getCombo();
        TextUtil.setWidth(combo, 6, 8);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        String memb = this.member;
        index = memb == null ? -1 : combo.indexOf(memb);
        combo.select(index);
        gridData = new GridData(32);
        gridData.horizontalSpan = 3;
        combo.setLayoutData((Object)gridData);
        this.createFiletypeGroup((Composite)source);
        source.setSize(source.computeSize(-1, -1));
    }

    private void createFiletypeGroup(Composite parent) {
        Group type = new Group(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        type.setLayout((Layout)layout);
        type.setLayoutData((Object)gridData);
        type.setText(String.valueOf(Messages.SchedulingDatasetDialog_12) + this.process);
        this.pdsRadioButton = new Button((Composite)type, 16);
        this.pdsRadioButton.setText("PDS");
        this.pdsRadioButton.setSelection(this.isPDS);
        gridData = new GridData(4, 2, true, false, 1, 1);
        this.pdsRadioButton.setLayoutData((Object)gridData);
        this.pdsRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SchedulingDatasetDialog.this.isPDS) {
                    SchedulingDatasetDialog.this.isPDS = true;
                    SchedulingDatasetDialog.this.filetype = "P";
                    SchedulingDatasetDialog.this.SourceMember.getCombo().setEnabled(true);
                }
            }
        });
        this.seqRadioButton = new Button((Composite)type, 16);
        this.seqRadioButton.setText(Messages.SchedulingDatasetDialog_15);
        this.seqRadioButton.setSelection(!this.isPDS);
        gridData = new GridData(4, 2, true, false, 1, 1);
        this.seqRadioButton.setLayoutData((Object)gridData);
        this.seqRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchedulingDatasetDialog.this.isPDS) {
                    SchedulingDatasetDialog.this.isPDS = false;
                    SchedulingDatasetDialog.this.filetype = "S";
                    SchedulingDatasetDialog.this.SourceMember.getCombo().setEnabled(false);
                    SchedulingDatasetDialog.this.SourceMember.getCombo().setText(SchedulingDatasetDialog.EMPTY);
                }
            }
        });
        type.setSize(type.computeSize(-1, -1));
    }

    protected void okPressed() {
        this.dsn = this.SourceDSN.getSelected();
        this.member = this.SourceMember.getSelected();
        boolean rc = this.verifyInput();
        if (rc) {
            this.SourceDSN.save();
            this.SourceMember.save();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.member = EMPTY;
        this.dsn = EMPTY;
        this.filetype = this.isPDS ? "P" : "S";
        super.cancelPressed();
    }

    private boolean verifyInput() {
        String string = this.filetype = this.isPDS ? "P" : "S";
        if (this.dsn == null) {
            this.dsn = EMPTY;
        }
        if (this.member == null) {
            this.member = EMPTY;
        }
        if (this.dsn.length() == 0) {
            String text = Messages.SchedulingDatasetDialog_26;
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchedulingDatasetDialog_27, (String)text);
            return false;
        }
        if (this.isPDS && this.member.length() == 0) {
            String text = Messages.SchedulingDatasetDialog_28;
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchedulingDatasetDialog_29, (String)text);
            return false;
        }
        return true;
    }

    public String getMember() {
        return this.isPDS ? this.member : EMPTY;
    }

    public String getDSN() {
        return this.dsn;
    }

    public String getFiletype() {
        return this.filetype;
    }
}

