/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LoadTraceDialog
extends ElementTreeSelectionDialog {
    public static final String MESSAGE = "Select the trace file from the Intertest projects. Projects currently being debugged are not listed.";
    public static final String TITLE = "Trace Resource Selection";
    public static Debug debug = Debug.getInstance();

    public LoadTraceDialog(Shell parentShell) {
        super(parentShell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                Object[] elements = super.getElements(element);
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object resourceElement = objectArray[n2];
                    debugSession session = debug.getSession((IResource)resourceElement);
                    if (session != null && !session.isDebugging()) {
                        result.add(resourceElement);
                    }
                    ++n2;
                }
                return result.toArray();
            }
        });
    }

    public int open() {
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IFile fileResource;
                return !(element instanceof IFile) || (fileResource = (IFile)element).getFileExtension().equalsIgnoreCase("trace");
            }
        });
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        return super.open();
    }

    public void create() {
        super.create();
        final Button okButton = this.getOkButton();
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection structSelection = (IStructuredSelection)selection;
                    if (structSelection.getFirstElement() instanceof IFile) {
                        okButton.setEnabled(true);
                    } else {
                        okButton.setEnabled(false);
                    }
                }
            }
        });
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return Status.CANCEL_STATUS;
                }
                if (selection[0] instanceof IFile) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        okButton.setEnabled(false);
        this.setDoubleClickSelects(false);
    }
}

