/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class IT_ErrorDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final IStatus[] standardStatus;
    private static final String provider;
    private static final String name;
    private static final String version;
    private static final String plugin = "com.ca.intertest";

    static {
        Bundle bundle = Platform.getBundle((String)plugin);
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            provider = (String)headers.get("Bundle-Vendor");
            name = (String)headers.get("Bundle-Name");
            version = (String)headers.get("Bundle-Version");
        } else {
            provider = "Unknown vendor";
            name = plugin;
            version = "Unknown version";
        }
        ArrayList<Status> list = new ArrayList<Status>(10);
        String[] stringArray = new String[]{"Plugin Vendor: %1$s", "Plugin Name: %2$s", "Plug-in ID: %3$s", "Version: %4$s", "Dummy"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            list.add(new Status(4, plugin, String.format(item, provider, name, plugin, version), null));
            ++n2;
        }
        standardStatus = new Status[list.size()];
        list.toArray(standardStatus);
    }

    public static void openError(Shell parent, String title, String message) {
        IT_ErrorDialog.openError(4, title, message, null);
    }

    public static void openError(Shell parent, String title, String message, Throwable e) {
        IT_ErrorDialog.openError(4, title, message, e);
    }

    public static void openError(int statuscode, String dialogTitle, String message, Throwable e) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String eventclass = stack.length > 1 ? stack[1].getClassName() : "Unknown class";
        IT_ErrorDialog.standardStatus[IT_ErrorDialog.standardStatus.length - 1] = new Status(4, plugin, String.format("The error was detected in %5$s", provider, name, plugin, version, eventclass), null);
        MultiStatus status = new MultiStatus(plugin, statuscode, standardStatus, e == null ? null : e.getMessage(), e);
        ErrorDialog.openError(null, (String)dialogTitle, (String)message, (IStatus)status);
    }
}

