/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.CoreExpressionDialog;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AutoDataViewPage;
import com.ca.intertest.ui.views.data.DataViewPage;
import com.ca.intertest.ui.views.data.SessionViewPage;
import com.ca.intertest.wizards.IMemoryWizard;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class CoreExprDumpDialog
extends CoreExpressionDialog {
    private static final String EMPTY = "";
    protected static final Debug debug = Debug.getInstance();

    public CoreExprDumpDialog(Shell parentShell) {
        super(parentShell);
    }

    public CoreExprDumpDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    @Override
    public void init(ListerEditor lsteditor, IResource res, String version, String cmd, int pgmlang, AbstractDataViewPage pageparm, debugSession currSession) {
        this.CONTEXT_ID = "coreExpressionDialog";
        this.page = pageparm;
        this.listeditor = lsteditor;
        this.title = String.valueOf(IMemoryWizard.CORE_WORD) + Messages.CoreExprDumpDialog_2;
        this.resource = res;
        this.session = (debugSession)debug.getResource((IResource)lsteditor.getResource().getProject());
        this.version = version;
        this.isCICS = this.session.isCICS();
        debugFile debugfile = (debugFile)debug.getResource(this.resource);
        this.lang = debugfile.getLanguage();
        this.initialCmd = cmd;
        this.setDump(pageparm == null);
        if (pageparm instanceof AutoDataViewPage || pageparm instanceof DataViewPage) {
            this.view = "com.ca.intertest.ui.views.dataview";
        } else if (pageparm instanceof SessionViewPage) {
            this.view = "com.ca.intertest.ui.views.sessionview";
        }
        this.serverType = this.isCICS ? "cics" : "batch";
        this.map = Keywords.getKeywords(this.serverType, version);
        Object[] keyobjs = this.map.keySet().toArray();
        Object[] objs = this.map.values().toArray();
        int j = 0;
        this.systemCount = 0;
        this.taskCount = 0;
        this.keywordCount = 0;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            XMLMemento xml = (XMLMemento)obj;
            this.key = keyobjs[j].toString();
            this.type = xml.getString("type");
            this.dsect = xml.getString("DSECT");
            this.view = "com.ca.intertest.ui.views.dataview";
            if (this.type.equals("system") || this.type.equals("task")) {
                this.view = "com.ca.intertest.ui.views.sessionview";
            }
            this.views.put(this.key, this.view);
            String str = xml.getTextData();
            int idx = str.indexOf("\n");
            if (idx > 0) {
                str = str.substring(0, idx);
            }
            str = String.valueOf(this.key) + " -- " + str;
            if (this.type != null) {
                if (this.type.equals("system")) {
                    this.cicsSystemAreasValues.add(str);
                    ++this.systemCount;
                } else if (this.type.equals("task")) {
                    this.cicsTaskAreasValues.add(str);
                    ++this.taskCount;
                } else if (this.type.equals("breakpoint")) {
                    this.keywordAreasValues.add(str);
                    ++this.keywordCount;
                } else if (this.type.equals("program")) {
                    this.programAreasValues.add(str);
                    ++this.programCount;
                }
            }
            ++j;
            ++n2;
        }
    }

    @Override
    protected void createSelectionGroup(Composite parent) {
        this.selectionGroup = new Group(parent, 0);
        this.selectionGroup.setText(Messages.CoreExprDumpDialog_5);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        this.selectionGroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.selectionGroup.setLayoutData((Object)this.gridData);
        this.createCoreExpressionRadioButton();
        if (this.systemCount > 0 && this.isCICS) {
            this.createCICSSystemAreasRadioButton();
        }
        if (this.taskCount > 0 && this.isCICS) {
            this.createCICSTaskAreasRadioButton();
        }
        if (this.keywordCount > 0) {
            this.createKeywordAreasRadioButton();
        }
        if (this.isCICS) {
            this.createProgramRadioButton();
        }
        if (this.lang == 16) {
            this.createAssemblerAreasRadioButton();
        }
        this.selectionGroup.setSize(this.selectionGroup.computeSize(-1, -1));
        this.createOptionsGroup(parent);
    }

    protected void okPressed() {
        this.errLevel = 0;
        this.exprCmd = EMPTY;
        this.keyWord = EMPTY;
        this.program = EMPTY;
        this.options = EMPTY;
        this.dsect = EMPTY;
        this.member = EMPTY;
        this.view = EMPTY;
        this.asmRegister = (short)-1;
        this.asmArgument = (short)-1;
        this.noDsect = false;
        if (this.coreExpressionRadioButton.getSelection()) {
            this.doCoreExpression();
        }
        if (this.systemCount > 0 && this.cicsSystemAreasRadioButton.getSelection()) {
            this.doCicsSystemAreas();
        }
        if (this.taskCount > 0 && this.cicsTaskAreasRadioButton.getSelection()) {
            this.doCicsTaskAreas();
        }
        if (this.keywordCount > 0 && this.keywordAreasRadioButton.getSelection()) {
            this.doKeywordAreas();
        }
        if (this.isCICS && this.programRadioButton.getSelection()) {
            this.doProgram();
        }
        if (this.lang == 16 && this.assemblerAreasRadioButton.getSelection()) {
            this.doAssemblerAreas();
        }
        this.doOptions();
        if (this.isCICS && this.program != EMPTY) {
            Logger.loggit(0, String.valueOf(IMemoryWizard.CORE_WORD) + Messages.CoreExprDumpDialog_6 + this.program);
        }
        this.doProcessKeywords();
        this.doProcessExpressions();
        if (this.errLevel < 5) {
            super.okPressed();
        }
    }

    @Override
    protected void checkSettings() {
        this.settings.put("expression", this.coreExpressionRadioButton.getSelection());
        if (this.systemCount > 0 && this.isCICS) {
            this.settings.put("system", this.cicsSystemAreasRadioButton.getSelection());
        }
        if (this.taskCount > 0 && this.isCICS) {
            this.settings.put("task", this.cicsTaskAreasRadioButton.getSelection());
        }
        if (this.keywordCount > 0) {
            this.settings.put("keyword", this.keywordAreasRadioButton.getSelection());
        }
        if (this.lang == 16) {
            this.settings.put("assembler", this.assemblerAreasRadioButton.getSelection());
        }
        if (this.isCICS) {
            this.settings.put("program", this.programRadioButton.getSelection());
        }
    }

    @Override
    protected int initSettings() {
        if (this.settings.getBoolean("expression")) {
            return 7;
        }
        if (this.systemCount > 0 && this.isCICS && this.settings.getBoolean("system")) {
            return 1;
        }
        if (this.taskCount > 0 && this.isCICS && this.settings.getBoolean("task")) {
            return 3;
        }
        if (this.keywordCount > 0 && this.settings.getBoolean("keyword")) {
            return 4;
        }
        if (this.lang == 16 && this.settings.getBoolean("assembler")) {
            return 6;
        }
        if (this.isCICS && this.settings.getBoolean("program")) {
            return 5;
        }
        return 0;
    }

    @Override
    protected void grayControls(int ptr) {
        if (this.systemCount > 0 && this.isCICS) {
            this.cicsSystemAreasCombo.setEnabled(this.setGray(ptr, 1));
        }
        if (this.taskCount > 0 && this.isCICS) {
            this.cicsTaskAreasCombo.setEnabled(this.setGray(ptr, 3));
        }
        if (this.keywordCount > 0) {
            this.keywordAreasCombo.setEnabled(this.setGray(ptr, 4));
        }
        if (this.isCICS) {
            this.programCombo.setEnabled(this.setGray(ptr, 5));
            this.programParmText.setEnabled(this.setGray(ptr, 9));
        }
        if (this.lang == 16) {
            this.baseText.setEnabled(this.setGray(ptr, 10));
            this.labelText.setEnabled(this.setGray(ptr, 11));
            this.registerText.setEnabled(this.setGray(ptr, 12));
            this.argumentText.setEnabled(this.setGray(ptr, 13));
            this.registerSymbolCombo.setEnabled(this.setGray(ptr, 12));
        }
        this.coreExpressionText.setEnabled(this.setGray(ptr, 22));
        this.offsetText.setEnabled(this.setGray(ptr, 26));
        this.whereCheckbox.setEnabled(this.setGray(ptr, 29));
        this.useProgramCombo.setEnabled(this.setGray(ptr, 27));
    }

    protected boolean setGray(int ptr, int idx) {
        if (idx == 0) {
            return false;
        }
        boolean flag = false;
        switch (ptr) {
            case 0: {
                flag = false;
                break;
            }
            case 7: {
                if (idx != 22 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 1: {
                if (idx != 1 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 3: {
                if (idx != 3 && idx != 7 && idx != 15 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 4: {
                if (idx != 4 && idx != 8 && idx != 16 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 5: {
                if (idx != 5 && idx != 9 && idx != 17 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 6: {
                if (idx != 10 && idx != 11 && idx != 12 && idx != 13 && idx != 18 && idx != 19 && idx != 20 && idx != 21 && idx != 26 && idx != 27 && idx != 29) break;
                flag = true;
                break;
            }
            case 8: {
                if (idx != 23 && idx != 24 && idx != 25 && idx != 28 && idx != 29) break;
                flag = true;
            }
        }
        return flag;
    }

    @Override
    protected void cancelPressed() {
        super.cancelPressed();
    }

    @Override
    protected void doCicsSystemAreas() {
        this.values = this.cicsSystemAreasCombo.getText().split(" ");
        IMemento im = (IMemento)this.map.get(this.values[0]);
        this.dsect = im.getString("DSECT");
        this.member = im.getString("member");
        if (this.dsect == null) {
            this.exprCmd = this.values[0];
            this.noDsect = true;
        } else {
            this.keyWord = this.values[0];
        }
        this.view = "com.ca.intertest.ui.views.sessionview";
    }

    @Override
    protected void doCicsTaskAreas() {
        this.values = this.cicsTaskAreasCombo.getText().split(" ");
        IMemento im = (IMemento)this.map.get(this.values[0]);
        this.dsect = im.getString("DSECT");
        this.member = im.getString("member");
        if (this.dsect == null) {
            this.exprCmd = this.values[0];
            this.noDsect = true;
        } else {
            this.keyWord = this.values[0];
        }
        this.view = "com.ca.intertest.ui.views.sessionview";
    }

    @Override
    protected void buildWhereCheckbox(Composite parent) {
        this.useWhere = true;
        this.whereCheckbox = new Button(parent, 32);
        this.whereCheckbox.setText("WHERE");
        this.gridData = new GridData(64);
        this.gridData.horizontalSpan = 1;
        this.gridData.widthHint = 100;
        this.whereCheckbox.setLayoutData((Object)this.gridData);
    }

    public TreeObject getTreeObject() {
        return this.treeobject;
    }

    public String getExpression() {
        return this.exprCmd;
    }

    public String getUseProgram() {
        return this.useProgram;
    }

    public String getUseStructure() {
        return this.useStructure;
    }
}

