/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.ConvertJCLMessage;
import com.ca.intertest.tools.ConvertedJCLMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.ITException;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ConvertJCL {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private ConvertJCLMessage convert = new ConvertJCLMessage();
    private ConvertedJCLMessage result;
    private FileServer server;
    private String batchDSN;
    private String batchStep;
    private String proclibList;
    private byte DSNType;
    private String convertDSN;
    private String errorText;
    private short status = 0;
    private FileName targetfile;

    public ConvertJCL(FileServer server, String batchDSN, String batchStep, String proclibList, byte DSNtype, String convertDSN) {
        this.server = server;
        this.batchDSN = batchDSN;
        this.batchStep = batchStep;
        this.proclibList = proclibList;
        this.DSNType = DSNtype;
        this.convertDSN = convertDSN;
    }

    public CVMO process() {
        CVMO cvmo = null;
        CVMI cvmi = null;
        FileConnection connection = new FileConnection(this.server);
        try {
            connection.connect(true);
            String[] parts = this.batchDSN.split("[()]");
            this.convert.setDSN(parts[0]);
            if (parts.length > 1) {
                this.convert.setMember(parts[1]);
            } else {
                this.convert.setMember(null);
            }
            this.convert.setStepname(this.batchStep);
            this.convert.setType(this.DSNType);
            this.convert.setProclibs(this.proclibList);
            String target = this.convertDSN.trim();
            this.convert.setUserID(this.server.getUser());
            if (target.length() > 0) {
                this.convert.setTarget(new FileName(1, target));
            }
            boolean more = true;
            while (more) {
                this.errorText = null;
                this.status = 0;
                cvmi = new CVMI();
                cvmi.addMessage((DebugMessage)this.convert);
                cvmo = connection.processTomcat(true, new HashMap<String, Object>(), cvmi);
                this.status = (short)connection.getErrorLevel();
                if (this.status > 0) {
                    this.errorText = cvmo.getErrorMessage();
                    Connection.displayError(cvmo, Messages.ConvertJCL_1);
                    more = false;
                    break;
                }
                DebugMessage msg = cvmo.getMessage(1);
                if (msg instanceof ConvertedJCLMessage) {
                    this.result = (ConvertedJCLMessage)msg;
                    this.status = this.result.getResult();
                    switch (this.status) {
                        case 0: {
                            this.batchDSN = this.convert.getDSN();
                            String member = this.convert.getMember();
                            if (member != null && member.length() > 0) {
                                this.batchDSN = String.format("%s(%s)", this.batchDSN, member);
                            }
                            this.batchStep = this.convert.getStepname();
                            this.status = 0;
                            this.targetfile = ((ConvertedJCLMessage)msg).getTarget();
                            more = false;
                            break;
                        }
                        case 1: {
                            more = false;
                            this.showError(Messages.ConvertJCL_3);
                            break;
                        }
                        case 2: {
                            more = this.missingMember();
                            break;
                        }
                        case 3: {
                            more = this.missingStep();
                            break;
                        }
                        case 4: {
                            more = false;
                            this.showError(Messages.ConvertJCL_4);
                        }
                    }
                    continue;
                }
                more = false;
                this.showError(Messages.ConvertJCL_5);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.showError(Messages.ConvertJCL_6, e);
            this.status = (short)64;
        }
        return cvmo;
    }

    private void showError(String message, Throwable e) {
        IT_ErrorDialog.openError(32, Messages.ConvertJCL_7, message, e);
    }

    private void showError(final String message) {
        final Display display = Display.getDefault();
        this.errorText = message;
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.ConvertJCL_7, (String)message);
                }
            });
        }
    }

    private boolean missingMember() {
        final Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    SelectMemberDialog dialog = new SelectMemberDialog(display.getActiveShell(), ConvertJCL.this.convert, ConvertJCL.this.result);
                    dialog.open();
                }
            });
            return this.result.getResult() == 0;
        }
        return false;
    }

    private boolean missingStep() {
        final Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    SelectStepDialog dialog = new SelectStepDialog(display.getActiveShell(), ConvertJCL.this.convert, ConvertJCL.this.result);
                    dialog.open();
                }
            });
            return this.result.getResult() == 0;
        }
        return false;
    }

    public CVMO process(CVMI cvmi, ServerElement server) {
        CVMO cvmo = null;
        FileConnection connection = new FileConnection(server);
        try {
            connection.connect(true);
            cvmo = connection.processTomcat(true, new HashMap<String, Object>(), cvmi);
        }
        catch (Exception e) {
            Logger.loggit(e);
            cvmo = new CVMO();
            StatusMessage status = new StatusMessage();
            status.setStatus((short)connection.getErrorLevel());
            status.setMessage(connection.getErrorMessage());
            cvmo.addMessage((DebugMessage)status);
            Connection.processStatusMessages(cvmi, cvmo);
        }
        return cvmo;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public short getStatus() {
        return this.status;
    }

    public FileName getTargetfile() {
        return this.targetfile;
    }

    public String getBatchDSN() {
        return this.batchDSN;
    }

    public String getBatchStep() {
        return this.batchStep;
    }

    public class SelectMemberDialog
    extends IntertestDialog {
        private ConvertJCLMessage convert;
        private ConvertedJCLMessage result;
        private List members;

        public SelectMemberDialog(Shell parentShell, ConvertJCLMessage convert, ConvertedJCLMessage result) {
            super(parentShell);
            this.convert = convert;
            this.result = result;
        }

        public SelectMemberDialog(IShellProvider parentShell, ConvertJCLMessage convert, ConvertedJCLMessage result) {
            super(parentShell);
            this.convert = convert;
            this.result = result;
        }

        protected void setShellStyle(int newShellStyle) {
            int style = newShellStyle | 0x40 | 0x20 | 0x80 | 0x10;
            super.setShellStyle(style);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ConvertJCL_8);
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            Label label = new Label(control, 0);
            label.setText(String.valueOf(Messages.ConvertJCL_9) + this.convert.getDSN());
            this.members = new List(control, 2564);
            GridData gridData = new GridData(4, 4, true, true, 2, 0);
            this.members.setLayoutData((Object)gridData);
            this.members.setItems(this.result.getMembers());
            this.members.select(0);
            return control;
        }

        protected void okPressed() {
            String member = this.members.getItem(this.members.getSelectionIndex());
            this.convert.setMember(member);
            try {
                this.result.setResult((short)0);
            }
            catch (ITException iTException) {}
            super.okPressed();
        }

        protected void cancelPressed() {
            try {
                this.result.setResult((short)5);
            }
            catch (ITException iTException) {}
            super.cancelPressed();
        }
    }

    public class SelectStepDialog
    extends IntertestDialog {
        private ConvertJCLMessage convert;
        private ConvertedJCLMessage result;
        private List steps;

        public SelectStepDialog(Shell parentShell, ConvertJCLMessage convert, ConvertedJCLMessage result) {
            super(parentShell);
            this.convert = convert;
            this.result = result;
        }

        public SelectStepDialog(IShellProvider parentShell, ConvertJCLMessage convert, ConvertedJCLMessage result) {
            super(parentShell);
            this.convert = convert;
            this.result = result;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ConvertJCL_10);
        }

        protected void setShellStyle(int newShellStyle) {
            int style = newShellStyle | 0x40 | 0x20 | 0x80 | 0x10;
            super.setShellStyle(style);
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            Label label = new Label(control, 0);
            label.setText(String.valueOf(Messages.ConvertJCL_9) + this.convert.getDSN());
            this.steps = new List(control, 2564);
            GridData gridData = new GridData(4, 4, true, true, 2, 0);
            this.steps.setLayoutData((Object)gridData);
            this.steps.setItems(this.result.getSteps());
            this.steps.select(0);
            return control;
        }

        protected void cancelPressed() {
            try {
                this.result.setResult((short)5);
            }
            catch (ITException iTException) {}
            super.cancelPressed();
        }

        protected void okPressed() {
            int ix = this.steps.getSelectionIndex();
            String stepname = this.steps.getItem(ix);
            this.convert.setStepix(ix + 1);
            String[] tokens = stepname.split(" ");
            this.convert.setStepname(tokens[0].substring(2));
            try {
                this.result.setResult((short)0);
            }
            catch (ITException iTException) {}
            super.okPressed();
        }
    }
}

