/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.VariableArrays;
import com.ca.intertest.dialogs.ArrayRow;
import com.ca.intertest.dialogs.IArrayRowListViewer;
import com.ca.intertest.tools.HexUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class ArrayRowList {
    private ByteBuffer backingdata;
    private Vector<ArrayRow> rows;
    private final Set<IArrayRowListViewer> changeListeners = new HashSet<IArrayRowListViewer>();
    private Variable variable;
    private int idx;
    ArrayRow row = null;
    int dimCnt = 0;
    int length;
    int mode;
    Integer[] base = new Integer[]{1, 1, 1, 1, 1, 1, 1};

    public void initData(Variable var, ByteBuffer bb, int pgmlang) {
        Integer[] dmax = new Integer[]{0, 0, 0, 0, 0, 0, 0};
        int rowCnt = 0;
        this.variable = var;
        this.backingdata = bb;
        this.base = ArrayRowList.getIndexBase(var, pgmlang);
        this.dimCnt = 0;
        this.mode = 2;
        this.length = (Integer)Attribute.getValue("length", this.variable);
        int i = 0;
        while (i < 7) {
            String key = "gt_dmax" + String.valueOf(i + 1);
            String str = this.variable.getAttribute(key);
            dmax[i] = str.length() > 0 ? Integer.valueOf(Integer.valueOf(str) - this.base[i] + 1) : Integer.valueOf(0);
            ++i;
        }
        Integer[] indexes = new Integer[]{0, 0, 0, 0, 0, 0, 0};
        if (dmax[0] > 0) {
            rowCnt = dmax[0];
            ++this.dimCnt;
            if (dmax[1] > 0) {
                rowCnt *= dmax[1].intValue();
                ++this.dimCnt;
                if (dmax[2] > 0) {
                    rowCnt *= dmax[2].intValue();
                    ++this.dimCnt;
                    if (dmax[3] > 0) {
                        rowCnt *= dmax[3].intValue();
                        ++this.dimCnt;
                        if (dmax[4] > 0) {
                            ++this.dimCnt;
                            rowCnt *= dmax[4].intValue();
                            if (dmax[5] > 0) {
                                rowCnt *= dmax[5].intValue();
                                ++this.dimCnt;
                                if (dmax[6] > 0) {
                                    rowCnt *= dmax[6].intValue();
                                    ++this.dimCnt;
                                }
                            }
                        }
                    }
                }
            }
        }
        this.rows = new Vector(rowCnt);
        this.idx = 0;
        if (dmax[0] > 0) {
            indexes[0] = 0;
            while (indexes[0] < dmax[0]) {
                if (dmax[1] > 0) {
                    indexes[1] = 0;
                    while (indexes[1] < dmax[1]) {
                        if (dmax[2] > 0) {
                            indexes[2] = 0;
                            while (indexes[2] < dmax[2]) {
                                if (dmax[3] > 0) {
                                    indexes[3] = 0;
                                    while (indexes[3] < dmax[3]) {
                                        if (dmax[4] > 0) {
                                            indexes[4] = 0;
                                            while (indexes[4] < dmax[4]) {
                                                if (dmax[5] > 0) {
                                                    indexes[5] = 0;
                                                    while (indexes[5] < dmax[5]) {
                                                        if (dmax[6] > 0) {
                                                            indexes[6] = 0;
                                                            while (indexes[6] < dmax[6]) {
                                                                this.doBuildRow(indexes, 6);
                                                                indexes[6] = indexes[6] + 1;
                                                            }
                                                        } else {
                                                            this.doBuildRow(indexes, 5);
                                                        }
                                                        indexes[5] = indexes[5] + 1;
                                                    }
                                                } else {
                                                    this.doBuildRow(indexes, 4);
                                                }
                                                indexes[4] = indexes[4] + 1;
                                            }
                                        } else {
                                            this.doBuildRow(indexes, 3);
                                        }
                                        indexes[3] = indexes[3] + 1;
                                    }
                                } else {
                                    this.doBuildRow(indexes, 2);
                                }
                                indexes[2] = indexes[2] + 1;
                            }
                        } else {
                            this.doBuildRow(indexes, 1);
                        }
                        indexes[1] = indexes[1] + 1;
                    }
                } else {
                    this.doBuildRow(indexes, 0);
                }
                indexes[0] = indexes[0] + 1;
            }
        }
    }

    public void doBuildRow(Integer[] idxs, int ptr) {
        String text;
        String hexvalue;
        ++this.idx;
        String cell = this.formCellString(idxs);
        int varLoc = VariableArrays.getArrayLth(this.variable, idxs, this.mode);
        Variable clonevar = this.getClone(this.variable);
        if (this.backingdata != null) {
            ((Buffer)this.backingdata).position(varLoc);
            byte[] bytes = new byte[this.length];
            this.backingdata.get(bytes);
            hexvalue = this.variable.getHexValue(bytes);
            try {
                text = this.variable.getValue(bytes);
            }
            catch (Exception e) {
                text = HexUtil.getErrorText((Throwable)e);
            }
            ByteBuffer clonebackingdata = ByteBuffer.wrap(bytes);
            clonevar.setBackingdata(clonebackingdata);
        } else {
            clonevar.setBackingdata(null);
            text = "";
            hexvalue = "";
        }
        clonevar.setAddress(this.variable.getAddress().add((long)varLoc));
        clonevar.setBackingdataAddress(clonevar.getAddress());
        clonevar.setAlternateName(String.valueOf(this.variable.getName()) + cell);
        int baseoffset = (Integer)Attribute.getValue("structureoffset", this.variable);
        clonevar.setBackingdataOffset(baseoffset);
        this.row = new ArrayRow(cell, text, hexvalue, varLoc, clonevar);
        this.rows.add(this.row);
    }

    public String formCellString(Integer[] idxs) {
        String cell = "[" + (idxs[0] + this.base[0]);
        int i = 1;
        while (i < this.dimCnt) {
            cell = String.valueOf(cell) + ", " + (idxs[i] + this.base[i]);
            ++i;
        }
        cell = String.valueOf(cell) + "]";
        return cell;
    }

    public Vector<ArrayRow> getRows() {
        return this.rows;
    }

    public void addRow() {
        ArrayRow row = new ArrayRow("New row", "", "", 0, null);
        this.rows.add(this.rows.size(), row);
        for (IArrayRowListViewer item : this.changeListeners) {
            item.addRow(row);
        }
    }

    public void removeRow(ArrayRow row) {
        this.rows.remove(row);
        for (IArrayRowListViewer item : this.changeListeners) {
            item.removeRow(row);
        }
    }

    public void rowChanged(ArrayRow row) {
        for (IArrayRowListViewer item : this.changeListeners) {
            item.updateRow(row);
        }
    }

    public void removeChangeListener(IArrayRowListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IArrayRowListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Variable getClone(Variable var) {
        Variable clonevariable = null;
        try {
            clonevariable = (Variable)var.clone();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return clonevariable;
    }

    public Variable getRowVarByIdx(int idx) {
        return this.rows.get(idx).getCloneVar();
    }

    public Variable getRowVarByCell(int loc) {
        for (ArrayRow rw : this.rows) {
            if (rw.getLocation() != loc) continue;
            return rw.getCloneVar();
        }
        return null;
    }

    public Variable getRowVarBySubscripts(Integer[] subs) {
        if (subs[0] == 0) {
            return null;
        }
        String cellString = this.formCellString(subs);
        for (ArrayRow rw : this.rows) {
            if (rw.getCellIndexes() != cellString) continue;
            return rw.getCloneVar();
        }
        return null;
    }

    public Variable getRowVarBySubscripts(String cellString) {
        for (ArrayRow rw : this.rows) {
            if (!rw.getCellIndexes().equals(cellString)) continue;
            return rw.getCloneVar();
        }
        return null;
    }

    public static Integer[] getIndexBase(Variable var, int lang) {
        Integer[] idxbase = new Integer[]{1, 1, 1, 1, 1, 1, 1};
        if (lang == 128) {
            int i = 0;
            while (i < 7) {
                String key = "pl1arlb" + String.valueOf(i + 1);
                String str = var.getAttribute(key);
                idxbase[i] = str.length() > 0 ? Integer.valueOf(str) : Integer.valueOf(1);
                ++i;
            }
        }
        return idxbase;
    }
}

