/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Snapshot;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.CICSQueueBreakpoints;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.QueueBreakpoints;
import com.ca.intertest.debug.RequestBreakpointMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.UnsetBreakpointMessage;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.GUEXIMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.PUEXIMessage;
import com.ca.intertest.tools.TerminateSessionMessage;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.PropertyChangeEvent;

public class debugCICSSession
extends debugSession {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected final ArrayList<String> list = new ArrayList();
    private String applID = this.store.getString("com.ca.intertest.applid");

    public debugCICSSession(IProject resource, Debug debug) throws ITException, CoreException {
        super(resource, debug);
        this.addDebugListener(this);
    }

    @Override
    protected QueueBreakpoints getQueue() {
        if (this.queue == null) {
            this.queue = new CICSQueueBreakpoints(this);
        }
        return this.queue;
    }

    @Override
    public boolean isBatch() {
        return false;
    }

    @Override
    public boolean isCICS() {
        return true;
    }

    @Override
    public void endSession() {
        if (this.isDebugging()) {
            this.sendUnsetBreakpointsMessages();
            this.resetDebug();
        }
    }

    @Override
    public synchronized void suspendSession() {
        if (this.isDebugging()) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new TerminateSessionMessage());
            debugEvent event = new debugEvent((Object)cvmi, null);
            this.fireDebugMessageListeners(event);
            for (debugFile debugfile : this.getMonitored(true)) {
                debugfile.fireDebugMessageListeners(event);
            }
            this.resetDebug();
        }
    }

    @Override
    public void sendUnsetBreakpointsMessages() {
        CVMI cvmi = new CVMI();
        try {
            cvmi.addMessage((DebugMessage)new SignonMessage(this.getServer()));
            cvmi.addMessage((DebugMessage)new InitMessage(this));
            for (debugFile file : this.getMonitored(true)) {
                if (!file.exists()) continue;
                BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
                int n = breakpointMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                    try {
                        BreakpointMessage[] breakpointMessageArray = BreakpointMessageFactory.getUnsetBPMessage(breakpoint);
                        int n3 = breakpointMessageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            BreakpointMessage message = breakpointMessageArray[n4];
                            cvmi.addMessage((DebugMessage)message);
                            ++n4;
                        }
                        breakpoint.setBreakpointID(0L);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                    ++n2;
                }
            }
            if (cvmi.size() > 2 && this.connection != null && this.connection.connect(true)) {
                this.connection.process(cvmi);
                ((CICSConnection)this.connection).terminateCICSSession();
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    @Override
    public String[] getUEXIT(boolean force) {
        if (this.list.size() == 0 || force) {
            this.list.clear();
            this.loadUEXIT();
            String items = this.store.getString("UEXIT");
            if (items != null) {
                String[] itemlist;
                String[] stringArray = itemlist = items.split(";");
                int n = itemlist.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    String[] args = item.split("=");
                    if (args.length == 2) {
                        int ix = Integer.parseInt(args[1]);
                        while (ix >= this.list.size()) {
                            this.list.add(null);
                        }
                        this.list.set(ix, args[0]);
                    }
                    ++n2;
                }
            }
        }
        return this.list.toArray(new String[this.list.size()]);
    }

    private void loadUEXIT() {
        try {
            this.connection.connect(false);
            CVMI cvmi = new CVMI();
            try {
                cvmi.addMessage((DebugMessage)new SignonMessage(this.getServer()));
                cvmi.addMessage((DebugMessage)new InitMessage(this));
            }
            catch (ITException iTException) {
                return;
            }
            cvmi.addMessage((DebugMessage)new GUEXIMessage());
            CVMO cvmo = this.connection.process(cvmi);
            if (this.connection.getErrorLevel() == 0) {
                DebugMessage msg = cvmo.getMessage(1);
                if (msg instanceof PUEXIMessage) {
                    PUEXIMessage message = (PUEXIMessage)msg;
                    this.store.setValue("UEXIT", message.getUEXIList());
                }
            } else {
                Connection.displayError(cvmo, Messages.debugCICSSession_2);
            }
            ((CICSConnection)this.connection).terminateCICSSession();
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public boolean isDataMonitor() {
        return false;
    }

    @Override
    public void setDataMonitor(boolean monitor) {
    }

    @Override
    public void setExecutionCount(boolean count) {
    }

    @Override
    public boolean isStatementTrace() {
        return false;
    }

    @Override
    public void setStatementTrace(boolean trace) {
    }

    @Override
    public boolean isExecutionCount() {
        return false;
    }

    @Override
    public void debugEventOccured(debugEvent event) {
        Object obj = event.getSource();
        if (obj instanceof CVMI) {
            this.setTraceInfo((CVMI)((Object)obj));
        } else if (obj instanceof CVMO) {
            this.setTraceLog((CVMO)((Object)obj));
        }
    }

    @Override
    public void buildBreakpointQueue() {
        try {
            this.addRBPBreakpoints();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        for (debugFile debugfile : this.getMonitored(true)) {
            try {
                debugfile.setEntered(true);
                if (debugfile.isSubModule()) continue;
                this.addMonitor(debugfile);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public String getType() {
        return "CICS".toLowerCase();
    }

    @Override
    public void setDebug() {
        this.debugging = true;
        for (debugFile file : this.debugfiles.values()) {
            if (!file.getResource().exists()) continue;
            BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                breakpoint.setBreakpointID(0L);
                ++n2;
            }
        }
    }

    @Override
    public void sendUnsetMonitorMessages() {
        CVMI cvmi = new CVMI();
        try {
            cvmi.addMessage((DebugMessage)new SignonMessage(this.getServer()));
            cvmi.addMessage((DebugMessage)new InitMessage(this));
            for (debugFile file : this.getMonitored(true)) {
                if (!file.exists()) continue;
                MonitorMessage message = new MonitorMessage(file);
                message.setEnabled(false);
                if (!file.isSubModule()) {
                    cvmi.addMessage((DebugMessage)message);
                }
                BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
                int n = breakpointMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                    breakpoint.setBreakpointID(0L);
                    ++n2;
                }
            }
            if (cvmi.size() > 2 && this.connection != null && this.connection.connect(true)) {
                this.connection.process(cvmi);
                ((CICSConnection)this.connection).terminateCICSSession();
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void postSnapshot(Snapshot snapshot, boolean monitor) {
        if (snapshot == null) {
            snapshot = this.getSnapshot();
        }
        if (snapshot == null) {
            return;
        }
        CVMI cvmi = new CVMI();
        try {
            cvmi.addMessage((DebugMessage)new SignonMessage(this.getServer()));
            cvmi.addMessage((DebugMessage)new InitMessage(this));
            this.buildCVMI(cvmi, snapshot, false);
            if (cvmi.size() > 2 && this.connection != null && this.connection.connect(true)) {
                this.connection.process(cvmi);
                ((CICSConnection)this.connection).terminateCICSSession();
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    private void buildCVMI(CVMI cvmi, Snapshot snapshot, boolean monitor) {
        FileType filetype = snapshot.getFiletype();
        switch (snapshot.getSnapshottype()) {
            case SETTING: {
                if (monitor) break;
                Object message = null;
                Snapshot parent = snapshot.getParent();
                String name = parent.getSnapshottype() == Snapshot.SnapshotType.SESSION ? "" : parent.getName();
                String markername = snapshot.getName();
                if (markername.equals("com.ca.intertest.breakpoint.rbp")) {
                    RequestBreakpointMessage RBPMessage = new RequestBreakpointMessage(snapshot.getID());
                    RBPMessage.setFiletype(filetype);
                    RBPMessage.setEnabled(false);
                    RBPMessage.setProgram(name);
                    message = RBPMessage;
                } else if (markername.startsWith("com.ca.intertest.breakpoint") || markername.equals("com.ca.intertest.monitor")) {
                    UnsetBreakpointMessage UBPMessage = new UnsetBreakpointMessage();
                    UBPMessage.setBreakpointID(snapshot.getID());
                    UBPMessage.setEnabled(false);
                    UBPMessage.setProgram(name);
                    if (UBPMessage.getBreakpointID() != 0L) {
                        message = UBPMessage;
                    }
                }
                if (message == null) break;
                cvmi.addMessage((DebugMessage)message);
                break;
            }
        }
        for (Snapshot item : snapshot.getChildren()) {
            this.buildCVMI(cvmi, item, monitor);
        }
    }

    @Override
    public boolean hasInitialBreakpoint() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object newvalue = event.getNewValue();
        if (event.getProperty().equals("com.ca.intertest.applid") && newvalue != null) {
            this.applID = newvalue.toString();
            if (this.applID != null) {
                this.store.setValue("com.ca.intertest.applid", this.applID);
                this.store.save();
            }
            return;
        }
    }

    @Override
    public boolean isDataMonitorOK() {
        return !this.getUserID().startsWith(".") || !this.getTermID().startsWith(".");
    }

    public String getUserID() {
        String value = this.store.getString("userid");
        if (value == null || value.length() == 0) {
            value = ".ANY";
        }
        return value;
    }

    public String getTermID() {
        String value = this.store.getString("termid");
        if (value == null || value.length() == 0) {
            value = ".ANY";
        }
        return value;
    }

    @Override
    public String getProjectType() {
        return "CICS";
    }

    public String getApplID() {
        return this.applID;
    }

    public void setApplID(String applID) {
        if (this.applID == null || !this.applID.equals(applID)) {
            this.applID = applID;
            if (applID != null) {
                this.store.setValue("com.ca.intertest.applid", applID);
            } else {
                this.store.setValue("com.ca.intertest.applid", "");
            }
            this.store.save();
        }
    }
}

