/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.SynchSymbolic;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import org.eclipse.swt.widgets.Display;

public class SynchSymbolic2 {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private SynchronizeMessage message = null;
    private FileServer server = null;
    private debugSession session = null;
    private String loadmodule;
    boolean doRefresh;

    public SynchSymbolic2(SynchronizeMessage msg, debugSession session, debugFile file) throws ITException {
        this.doRefresh = true;
        this.init(msg, session, file);
    }

    public SynchSymbolic2(SynchronizeMessage msg, debugSession session, debugFile file, boolean doRefresh) throws ITException {
        this.doRefresh = doRefresh;
        this.init(msg, session, file);
    }

    public void init(SynchronizeMessage msg, debugSession session, debugFile file) throws ITException {
        this.message = msg;
        this.session = Debug.getInstance().getSession(this.message.getSessionID());
        if (this.session == null) {
            this.session = session;
            if (this.session == null) {
                throw new ITException(Messages.SynchSymbolic2_0);
            }
        }
        this.server = this.session.getServer();
        if (this.server == null) {
            throw new ITException(Messages.SynchSymbolic2_1);
        }
        this.loadmodule = file == null ? null : file.getName();
    }

    public CVMI synchronizeFile() {
        return this.synchronizeFile(null);
    }

    public CVMI synchronizeFile(String errorMsg) {
        SynchronizeMessage.SynchProtsym prot;
        Logger.loggit(0, String.format(Messages.SynchSymbolic2_2, this.message.getProgram(), this.session.getName()));
        SynchSymbolicMessage synchsymbol = new SynchSymbolicMessage();
        try {
            synchsymbol.setSubmessageID((short)3);
        }
        catch (ITException iTException) {}
        CVMI cvmi = new CVMI();
        cvmi.addMessage((DebugMessage)synchsymbol);
        String progname = this.message.getProgram();
        synchsymbol.setProgram(progname);
        if (this.loadmodule != null && !progname.equalsIgnoreCase(this.loadmodule)) {
            progname = String.valueOf(this.loadmodule) + "_" + progname;
            synchsymbol.setProgram(progname);
            this.message.setProgram(progname);
        }
        if (!this.doRefresh) {
            return cvmi;
        }
        if (this.message.getProtsyms().size() == 1 && ((prot = (SynchronizeMessage.SynchProtsym)this.message.getProtsyms().get(0)).isExact() || this.message.isZeroDate())) {
            try {
                synchsymbol.setSubmessageID((short)1);
            }
            catch (ITException e) {
                Logger.loggit(e);
            }
            synchsymbol.setDDName(prot.getDDName());
            synchsymbol.setDSN(prot.getDSN());
            synchsymbol.setSelection(1);
            synchsymbol.setDate(prot.getDate());
            synchsymbol.setTime(prot.getTime());
            this.session.refreshFile(progname, prot.getDSN(), true, false, true, prot.getDate(), prot.getTime(), "SynchSymbolic2");
            return cvmi;
        }
        Display display = Display.getDefault();
        if (display != null) {
            SynchSymbolic synch = new SynchSymbolic(this.session, synchsymbol, this.message, errorMsg);
            display.syncExec((Runnable)synch);
            synch.getFile();
        }
        return cvmi;
    }
}

