/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugCICSSessionJob;
import com.ca.intertest.debug.DebugSessionSetup;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.INQSYSMessage;
import com.ca.intertest.tools.INQSYSResponseMessage;
import com.ca.intertest.tools.ITException;
import org.eclipse.core.runtime.jobs.Job;

public class DebugCICSSessionSetup
extends DebugSessionSetup {
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    public DebugCICSSessionSetup(debugSession session) throws ITException, Exception {
        super(session);
    }

    @Override
    protected boolean connect() {
        try {
            this.connection = new CICSConnection(this.server, this.session);
            this.connection.connect(false);
            this.session.setConnection(this.connection);
            CVMO cvmo = this.setSessionInfo();
            return cvmo.getErrorLevel() == 0;
        }
        catch (Exception e) {
            Logger.loggit(e);
            return false;
        }
    }

    @Override
    public Job launch() throws Exception {
        DebugCICSSessionJob debugCICSJob = new DebugCICSSessionJob(String.valueOf(Messages.DebugCICSSessionSetup_1) + this.session.getName(), this.session, this.connection);
        debugCICSJob.setPriority(30);
        debugCICSJob.schedule();
        this.session.setInitializationJob(debugCICSJob);
        return debugCICSJob;
    }

    private CVMO setSessionInfo() {
        CVMO cvmo = new CVMO();
        CVMI cvmi = new CVMI();
        try {
            cvmi.addMessage((DebugMessage)new SignonMessage(this.session.getServer()));
            cvmi.addMessage((DebugMessage)new InitMessage(this.session));
            cvmi.addMessage((DebugMessage)new INQSYSMessage());
            if (this.connection != null && this.connection.connect(true)) {
                cvmo = this.connection.process(cvmi);
                if (cvmo.getErrorLevel() == 0) {
                    DebugMessage[] debugMessageArray = cvmo.getMessages();
                    int n = debugMessageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugMessage message = debugMessageArray[n2];
                        if (message.getMessageID() == 48) {
                            INQSYSResponseMessage inqmsg = (INQSYSResponseMessage)message;
                            this.session.setVersion(inqmsg.getSystemVersion());
                            this.session.setAFloat(inqmsg.isAFloat());
                            this.session.setWideRegs(inqmsg.isWideRegs());
                        }
                        ++n2;
                    }
                } else {
                    Connection.displayError(cvmo, Messages.DebugCICSSessionSetup_0);
                }
                ((CICSConnection)this.connection).terminateCICSSession();
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return cvmo;
    }
}

