/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.WSConnection;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GDSNMessage;
import com.ca.intertest.tools.ITException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DebugBatchSessionJob
extends Job {
    private debugSession session;
    private WSConnection connection;

    public DebugBatchSessionJob(String name, debugSession session, WSConnection connection) {
        super(name);
        this.session = session;
        this.connection = connection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.DebugBatchSessionJob_2, 3);
        CVMI cvmi = new CVMI();
        FileServer server = this.session.getServer();
        IStatus resultStatus = Status.OK_STATUS;
        this.session.setDebug();
        try {
            cvmi.addMessage((DebugMessage)new InitMessage(this.session));
        }
        catch (ITException e) {
            return new Status(4, Messages.StartDebugAction_Title, Messages.StartDebugAction_Reason_text, (Throwable)e);
        }
        catch (Exception e) {
            return new Status(4, Messages.StartDebugAction_Title, Messages.StartDebugAction_Reason_text, (Throwable)e);
        }
        for (String item : ((debugBatchSession)this.session).getProtsymlist()) {
            GDSNMessage msg = new GDSNMessage();
            msg.setDSName(item);
            cvmi.addMessage((DebugMessage)msg);
        }
        int count = cvmi.size();
        this.session.buildBreakpointQueue();
        this.session.getQueue().buildMonitoredList(cvmi);
        monitor.worked(1);
        if (cvmi.size() == count) {
            ITException itException = new ITException(Messages.DebugBatchSessionJob_0);
            return new Status(4, Messages.StartDebugAction_Title, Messages.StartDebugAction_Reason_text, (Throwable)itException);
        }
        monitor.setTaskName(Messages.DebugBatchSessionJob_3);
        SignonMessage signOnMessage = new SignonMessage();
        signOnMessage.setUserid(server.getUser());
        signOnMessage.setPassword(server.getPassword());
        cvmi.addMessage((DebugMessage)signOnMessage);
        this.connection.setDebugSession(this.session);
        this.connection.processSubmitJob(cvmi);
        monitor.worked(1);
        monitor.setTaskName(Messages.DebugBatchSessionJob_4);
        monitor.worked(1);
        int rc = this.connection.getErrorLevel();
        if (rc == 0) {
            final debugEvent event = new debugEvent((Object)cvmi, null);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DebugBatchSessionJob.this.session.fireDebugMessageListeners(event);
                }
            });
        } else {
            resultStatus = new Status(4, Messages.StartDebugAction_Title, String.valueOf(Messages.StartDebugAction_Reason_text) + ": " + this.connection.getErrorMessage());
            this.session.resetDebug();
        }
        return resultStatus;
    }

    protected void canceling() {
        this.session.endSession();
        super.canceling();
        this.connection.notifyClient();
    }
}

