/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.IActionListener;
import com.ca.intertest.common.IViewConnector;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugCICSSession;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.actions.LoadTraceDataAction;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class Debug {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final Debug debug = new Debug();
    private ArrayList<debugSession> sessions;
    private ListenerList propertyChangeListeners = new ListenerList();
    private IWorkspaceRoot root;
    private boolean runsilent = true;
    private IResourceChangeListener listener;
    private ArrayList<IViewConnector> viewsList = new ArrayList();
    private IEditorPart editor;
    private ArrayList<IActionListener> actionListener = new ArrayList();
    private LoadTraceDataAction loadTraceAction = null;

    private Debug() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.root = workspace.getRoot();
        try {
            this.root.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        this.sessions = new ArrayList();
        this.load();
        this.listener = new ResourceChangeListener();
        workspace.addResourceChangeListener(this.listener, 1);
    }

    private void disposeAll() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
        for (debugSession session : this.sessions) {
            session.dispose();
        }
    }

    private void load() {
        this.runsilent = true;
        IProject[] iProjectArray = this.root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && project.hasNature("com.ca.intertest.natures.intertest")) {
                    this.addDebugSession((IResource)project);
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            catch (ITException e) {
                Logger.loggit(e);
            }
            ++n2;
        }
        Iterator<debugSession> it = this.sessions.iterator();
        while (it.hasNext()) {
            debugSession item = it.next();
            if (item.getResource().isAccessible()) continue;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)item, null);
            this.firePropertyChangeListeners(event);
            it.remove();
        }
        this.runsilent = false;
    }

    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public synchronized void firePropertyChangeListeners(PropertyChangeEvent event) {
        if (!this.runsilent) {
            Object[] objectArray = this.propertyChangeListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPropertyChangeListener)listener).propertyChange(event);
                ++n2;
            }
        }
    }

    public final List<debugSession> getSessions() {
        ArrayList<debugSession> sessionlist = new ArrayList<debugSession>(this.sessions.size());
        for (debugSession session : this.sessions) {
            if (!session.getResource().isAccessible()) continue;
            sessionlist.add(session);
        }
        return sessionlist;
    }

    public debugSession getSession(Integer uid) {
        if (uid == null) {
            return null;
        }
        for (debugSession session : this.sessions) {
            if (!session.equals(uid) || !session.getResource().isAccessible()) continue;
            return session;
        }
        return null;
    }

    public debugSession getSession(IResource res) {
        IProject proj = res.getProject();
        for (debugSession session : this.sessions) {
            IResource resource = session.getResource();
            if (!resource.equals((Object)proj)) continue;
            return session;
        }
        return null;
    }

    public debugSession addDebugSession(IResource res) throws ITException {
        try {
            res.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        debugSession session = this.getSession(res);
        if (session == null) {
            try {
                IProject project = res.getProject();
                session = project.hasNature("com.ca.intertest.natures.cics") ? new debugCICSSession(project, this) : new debugBatchSession(project, this);
                for (debugSession item : this.sessions) {
                    if (!item.getUID().equals(session.getUID())) continue;
                    Logger.loggit(4, String.format(Messages.Debug_1, session.getName()));
                    session.resetUID();
                }
                this.sessions.add(session);
            }
            catch (CoreException coreException) {}
        }
        if (res.getType() == 1) {
            session.addDebugfile(res);
        }
        return session;
    }

    public void removeDebugSession(final debugSession session) {
        if (session.getResource().exists()) {
            IWorkspaceRunnable killit = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IProject project = (IProject)session.getResource();
                    int deleteFlag = 4;
                    try {
                        IProjectDescription description = project.getDescription();
                        URI path = description.getLocationURI();
                        if (path != null) {
                            deleteFlag = 8;
                            IResource projectfile = project.findMember(".project");
                            projectfile.delete(true, null);
                            session.deleteAllDebugfiles();
                        }
                    }
                    catch (CoreException coreException) {}
                    project.delete(deleteFlag | 1, null);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(killit, (ISchedulingRule)session.getResource(), 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public boolean hasChildren() {
        return this.sessions.size() > 0;
    }

    public IDebug getResource(IResource resource) {
        debugSession session = this.getSession(resource);
        if (session != null) {
            switch (resource.getType()) {
                case 4: {
                    return session;
                }
                case 1: {
                    return session.getFile(resource);
                }
            }
        }
        return null;
    }

    public static final synchronized Debug getInstance() {
        return debug;
    }

    public static final void dispose() {
        debug.disposeAll();
    }

    public IEditorPart openListerEditor(final String programName, debugSession session) {
        if (session == null) {
            return null;
        }
        this.editor = this.findListerEditor(programName, session);
        if (this.editor != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)Debug.this.editor);
                }
            });
            return this.editor;
        }
        final debugFile debugfile = session.getFile(programName);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
                    if (debugfile != null) {
                        Debug.this.editor = part.getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)debugfile.getResource()), "com.ca.intertest.ui.lister");
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DebugTalker_9, (String)String.format(Messages.DebugTalker_10, programName));
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
        return this.editor;
    }

    private IEditorPart findListerEditor(String programName, debugSession session) {
        final debugFile debugfile = session.getFile(programName);
        if (debugfile == null) {
            return null;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
                Debug.this.editor = part.getSite().getPage().findEditor((IEditorInput)new FileEditorInput((IFile)debugfile.getResource()));
            }
        });
        return this.editor;
    }

    public void addItemToViewsList(IViewConnector item) {
        this.viewsList.add(item);
    }

    public void notifyViewForRefresh(debugSession session) {
        for (IViewConnector view : this.viewsList) {
            view.refresh(session);
        }
    }

    public void addItemToActionListenerList(IActionListener item) {
        this.actionListener.add(item);
    }

    public void removeItemActionFromListenerList(IActionListener item) {
        if (item != null) {
            this.actionListener.remove(item);
        }
    }

    public void notifyBreakpointActionperformed() {
        for (IActionListener listener : this.actionListener) {
            listener.actionPerformed();
        }
    }

    public void setLoadTraceAction(LoadTraceDataAction loadTraceAction) {
        this.loadTraceAction = loadTraceAction;
    }

    public debugSession getLoadedSession() {
        if (this.loadTraceAction != null) {
            return this.loadTraceAction.getSession();
        }
        return null;
    }

    private class DeltaWalker
    implements IResourceDeltaVisitor {
        private DeltaWalker() {
        }

        public synchronized boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            IProject project = res.getProject();
            if (project == null || !(res instanceof IProject)) {
                return true;
            }
            debugSession session = Debug.this.getSession(res);
            try {
                if (session != null || res.getType() == 4 && project.hasNature("com.ca.intertest.natures.intertest")) {
                    int kind = delta.getKind();
                    PropertyChangeEvent event = null;
                    switch (kind) {
                        case 2: {
                            if (session == null) break;
                            Debug.this.sessions.remove(session);
                            event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)session, null);
                            session.dispose();
                            break;
                        }
                        case 1: {
                            if (!project.isAccessible()) break;
                            session = Debug.this.addDebugSession(res);
                            event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", null, (Object)session);
                            break;
                        }
                        case 16384: {
                            if (project.isOpen()) {
                                session = Debug.this.addDebugSession(res);
                                event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", null, (Object)session);
                                break;
                            }
                            Debug.this.sessions.remove(session);
                            event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)session, null);
                            break;
                        }
                        case 4: {
                            if (session == null) {
                                session = Debug.this.addDebugSession(res);
                                event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", null, (Object)session);
                            } else {
                                event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)session, (Object)session);
                            }
                            session.refresh();
                        }
                    }
                    if (event != null) {
                        Debug.this.firePropertyChangeListeners(event);
                    }
                }
            }
            catch (Exception exception) {}
            return true;
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new DeltaWalker());
            }
            catch (CoreException coreException) {}
        }
    }
}

