/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IConditionalBreakpointMessage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ConditionalBreakpointMessage
extends com.ca.intertest.tools.ConditionalBreakpointMessage
implements IConditionalBreakpointMessage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    public ConditionalBreakpointMessage(IMarker marker) throws CoreException {
        this();
        IResource res = marker.getResource();
        this.setProgram(decorator.getShortName(res));
        BreakpointMessageFactory.setAttributes((BreakpointMessage)this, marker);
        this.setIsCICS(marker.getAttribute("CICS"));
    }

    public ConditionalBreakpointMessage(BreakpointMarker marker) throws CoreException {
        this(marker.getMarker());
        this.breakpointID = marker.getBreakpointID();
    }

    public ConditionalBreakpointMessage() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (!(object instanceof BreakpointMarker)) {
            return super.equals(object);
        }
        BreakpointMarker marker = (BreakpointMarker)object;
        try {
            if (marker.getType().equals("com.ca.intertest.breakpoint.conditional")) {
                return false;
            }
            int subtype = marker.getAttribute("sub_type", -1);
            if (subtype != this.getSubmessageID()) {
                return false;
            }
            switch (subtype) {
                case 1: {
                    return false;
                }
                case 2: {
                    int statement = marker.getAttribute("stmtNumber", -2);
                    return statement == this.getStatement();
                }
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

