/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.MonitorOptionsMessage;
import com.ca.intertest.debug.QueueBreakpoints;
import com.ca.intertest.debug.RequestBreakpointMessage;
import com.ca.intertest.debug.SetBacktraceMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.UnsetBreakpointMessage;
import com.ca.intertest.debug.debugCICSSession;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.CompositeListMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.wizards.CompositeSetupPage;
import com.ca.intertest.wizards.CompositeSetupWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;

public class CICSQueueBreakpoints
extends QueueBreakpoints {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private DebugMessage[] header = new DebugMessage[2];
    private CICSConnection connection = null;

    public CICSQueueBreakpoints(debugSession session) {
        super(session);
        this.connection = (CICSConnection)session.getConnection();
    }

    @Override
    protected synchronized void post(IProgressMonitor progressMonitor) throws Exception {
        this.connection = (CICSConnection)this.session.getConnection();
        if (this.session.isDebugging()) {
            CVMO cvmo = new CVMO();
            CVMI cvmi = new CVMI();
            this.header[0] = new SignonMessage(this.session.getServer());
            this.header[1] = new InitMessage(this.session);
            if (this.connection != null) {
                debugFile[] items;
                debugFile[] debugFileArray = items = this.monitors.toArray(new debugFile[this.monitors.size()]);
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    debugFile item = debugFileArray[n2];
                    if (progressMonitor != null) {
                        progressMonitor.subTask(item.getName());
                    }
                    if (this.connection.connect(true)) {
                        this.connection.setFile(item);
                        if (item.isModule()) {
                            cvmi.setMessages(this.header);
                            this.processMonitored(item, cvmi);
                        } else if (item.isMainModule()) {
                            cvmi.setMessages(this.header);
                            this.processComposite(item, cvmi);
                        }
                    }
                    cvmi.setMessages(this.header);
                    this.buildMessages(cvmi);
                    if (cvmi.size() > 2 && this.connection.connect(true)) {
                        cvmo = this.connection.process(cvmi);
                        Connection.displayError(cvmo, Messages.CICSQueueBreakpoints_0);
                        this.postbreakpoints(cvmi, cvmo);
                        this.connection.terminateCICSSession();
                    }
                    if (progressMonitor != null) {
                        progressMonitor.worked(1);
                    }
                    ++n2;
                }
            }
            this.monitors.clear();
            cvmi.setMessages(this.header);
            this.buildMessages(cvmi);
            if (cvmi.size() > 2 && this.connection.connect(true)) {
                cvmo = this.connection.process(cvmi);
                Connection.displayError(cvmo, Messages.CICSQueueBreakpoints_1);
                this.postbreakpoints(cvmi, cvmo);
                this.connection.terminateCICSSession();
            }
        }
    }

    private void processComposite(debugFile file, CVMI cvmi) {
        try {
            CVMO cvmo = new CVMO();
            boolean result = true;
            if (file.isMonitor()) {
                this.addBreakpoints(file);
                final debugFile dbFile = file;
                CompositeSetupWizard wizard = new CompositeSetupWizard(dbFile, CompositeSetupPage.CompositeType.STANDARD, null, false);
                final IntertestWizardDialog dialog = new IntertestWizardDialog(null, (IWizard)wizard);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean result;
                        dialog.create();
                        boolean bl = result = dialog.open() == 0;
                        if (result) {
                            ArrayList<debugFile> files = new ArrayList<debugFile>();
                            files.add(dbFile);
                            String prefix = dbFile.getPrefix();
                            for (debugFile item : CICSQueueBreakpoints.this.session.getMonitored(true)) {
                                if (!item.getName().startsWith(prefix)) continue;
                                files.add(item);
                            }
                            for (debugFile item : files) {
                                if (dbFile.isMonitor()) {
                                    item.setEntered(dbFile.isMonitor());
                                    continue;
                                }
                                CICSQueueBreakpoints.this.clearBreakpoints(item);
                            }
                        } else {
                            dbFile.setMonitor(false, false);
                        }
                    }
                });
            } else {
                cvmi.addMessage((DebugMessage)new MonitorMessage(file));
                cvmo = this.connection.process(cvmi);
                Connection.displayError(cvmo, Messages.CICSQueueBreakpoints_2);
                boolean bl = result = cvmo.getErrorLevel() < 8;
                if (result) {
                    ArrayList<debugFile> files = new ArrayList<debugFile>();
                    files.add(file);
                    String prefix = file.getPrefix();
                    for (debugFile item : this.session.getMonitored(true)) {
                        if (!item.getName().startsWith(prefix)) continue;
                        files.add(item);
                    }
                    for (debugFile item : files) {
                        if (file.isMonitor()) {
                            item.setEntered(file.isMonitor());
                            continue;
                        }
                        this.clearBreakpoints(item);
                    }
                } else {
                    file.setMonitor(false, false);
                }
            }
            return;
        }
        catch (Exception e) {
            Logger.loggit(e);
            return;
        }
    }

    private void processMonitored(debugFile file, CVMI cvmi) {
        try {
            if (file.isMonitor() || !file.isSubModule()) {
                cvmi.addMessage((DebugMessage)new MonitorMessage(file));
            }
            CVMO cvmo = this.connection.process(cvmi);
            Connection.displayError(cvmo, Messages.CICSQueueBreakpoints_3);
            if (cvmo.getErrorLevel() < 8) {
                if (file.isMonitor()) {
                    boolean synched = !file.isProgram();
                    DebugMessage[] debugMessageArray = cvmo.getMessages();
                    int n = debugMessageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugMessage msg = debugMessageArray[n2];
                        switch (msg.getMessageID()) {
                            case 41: {
                                this.processCompositeMap(msg, file);
                                synched = true;
                            }
                        }
                        ++n2;
                    }
                    if (!synched) {
                        this.getsynchroInfo(file);
                    }
                    this.addBreakpoints(file);
                    if (file.isExecutionCount()) {
                        this.addExecutionCount(file, false, (short)1);
                    }
                    if (file.isStatementTrace()) {
                        this.addStatementTrace(file, false);
                        if (file.isDataMonitor()) {
                            this.addDataMonitor(file, false);
                        }
                    }
                    file.setEntered(file.isMonitor());
                } else {
                    this.clearBreakpoints(file);
                }
            } else {
                file.setMonitor(false, false);
            }
            this.connection.terminateCICSSession();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    private void processCompositeMap(DebugMessage msg, debugFile file) {
        CompositeListMessage compmsg = (CompositeListMessage)msg;
        boolean result = true;
        CompositeSetupWizard wizard = new CompositeSetupWizard(file, CompositeSetupPage.CompositeType.PRELOADED, compmsg.getCSects(), false);
        IntertestWizardDialog dialog = new IntertestWizardDialog(null, (IWizard)wizard);
        dialog.create();
        boolean bl = result = dialog.open() == 0;
        if (result) {
            ArrayList<debugFile> files = new ArrayList<debugFile>();
            files.add(file);
            String prefix = file.getPrefix();
            for (debugFile item : this.session.getMonitored(true)) {
                if (!item.getName().startsWith(prefix)) continue;
                files.add(item);
            }
            for (debugFile item : files) {
                item.setEntered(file.isMonitor());
                try {
                    this.addBreakpoints(item);
                    if (file.isExecutionCount()) {
                        this.addExecutionCount(file, false, (short)1);
                    }
                    if (!file.isStatementTrace()) continue;
                    this.addStatementTrace(file, false);
                    if (!file.isDataMonitor() || !this.session.isDataMonitorOK()) continue;
                    this.addDataMonitor(file, false);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
        }
    }

    @Override
    protected void buildMessages(CVMI cvmi) {
        Iterator rbpit = this.rbpmap.iterator();
        while (rbpit.hasNext()) {
            Object item = (BreakpointMarker)rbpit.next();
            try {
                BreakpointMessage[] messages = BreakpointMessageFactory.getInstance(item);
                RequestBreakpointMessage message = (RequestBreakpointMessage)messages[0];
                if (message == null) continue;
                cvmi.addMessage((DebugMessage)message);
                rbpit.remove();
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        for (Object item : this.bkpts) {
            if (!((BreakpointMarker)item).isValid()) continue;
            try {
                BreakpointMessage[] postits = BreakpointMessageFactory.getInstance(item);
                BreakpointMessage postit = postits[0];
                if (postit instanceof UnsetBreakpointMessage) {
                    if (postit.getBreakpointID() == 0L) {
                        postits = null;
                    } else {
                        ((BreakpointMarker)item).setBreakpointID(0L);
                    }
                    debugFile debugfile = this.session.getFile(((BreakpointMarker)item).getResource());
                    debugfile.removeBreakpointMarker(((BreakpointMarker)item).getMarker());
                } else if (postit.getBreakpointID() != 0L) {
                    postits = null;
                }
                if (postits == null) continue;
                BreakpointMessage[] breakpointMessageArray = postits;
                int n = postits.length;
                int n2 = 0;
                while (n2 < n) {
                    BreakpointMessage msg = breakpointMessageArray[n2];
                    cvmi.addMessage((DebugMessage)msg);
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        this.bkpts.clear();
        for (Object item : this.counts) {
            cvmi.addMessage((DebugMessage)item);
        }
        this.counts.clear();
        for (Object message : this.traces) {
            cvmi.addMessage((DebugMessage)message);
        }
        this.traces.clear();
        for (Object message : this.datamonitor) {
            cvmi.addMessage((DebugMessage)message);
        }
        this.datamonitor.clear();
        for (Object message : this.monitoroptions) {
            MonitorOptionsMessage optionsmessage = new MonitorOptionsMessage((BreakpointMarker)message);
            if (optionsmessage.isEnabled() || !optionsmessage.hasOID()) {
                cvmi.addMessage((DebugMessage)optionsmessage);
                continue;
            }
            try {
                UnsetBreakpointMessage unset = new UnsetBreakpointMessage((BreakpointMarker)message);
                if (unset.getBreakpointID() == 0L) continue;
                cvmi.addMessage((DebugMessage)unset);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        this.monitoroptions.clear();
    }

    @Override
    public void addExecutionCount(IDebug resource, boolean force, short subId) throws Exception {
        if (resource instanceof debugSession) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (force || resource.isExecutionCount()) {
            ExecutionCountsMessage msg = new ExecutionCountsMessage(resource);
            if (subId < 0) {
                msg.setSubmessageID((short)1);
            } else {
                msg.setSubmessageID(subId);
            }
            this.counts.add(msg);
        }
    }

    @Override
    public void addStatementTrace(IDebug resource, boolean force) throws Exception {
        if (resource instanceof debugSession) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (!resource.isStatementTrace()) {
            return;
        }
        this.traces.add(new SetBacktraceMessage(resource, "back_trace"));
    }

    @Override
    public void addDataMonitor(IDebug resource, boolean force) throws Exception {
        if (resource instanceof debugSession) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (!resource.isDataMonitor()) {
            return;
        }
        if (!resource.isStatementTrace()) {
            return;
        }
        if (!this.session.isDataMonitorOK()) {
            String message = String.format(Messages.CICSQueueBreakpoints_6, ((debugCICSSession)this.session).getTermID(), ((debugCICSSession)this.session).getUserID());
            Logger.loggit(4, message);
            return;
        }
        this.datamonitor.add(new SetBacktraceMessage(resource, "data_monitor"));
    }

    @Override
    public void buildMonitoredList(CVMI cvmi) {
    }

    private void getsynchroInfo(debugFile file) {
        CVMO cvmo = null;
        CVMI cvmi = new CVMI();
        try {
            if (!this.connection.connect(false)) {
                return;
            }
            try {
                cvmi.addMessage(this.header[0]);
                SynchSymbolicMessage sychrequest = new SynchSymbolicMessage();
                sychrequest.setSubmessageID((short)5);
                sychrequest.setProgram(file.getName());
                cvmi.addMessage((DebugMessage)sychrequest);
            }
            catch (ITException iTException) {
                return;
            }
            cvmo = this.connection.process(cvmi);
            if (cvmo.getErrorLevel() != 0) {
                Connection.displayError(cvmo, Messages.CICSQueueBreakpoints_4);
                return;
            }
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                if (message.getMessageID() == 45) {
                    this.refreshFile(file, message);
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            return;
        }
        this.connection.terminateCICSSession();
    }

    private void refreshFile(debugFile file, DebugMessage message) {
        SynchronizeMessage.SynchProtsym prot;
        SynchronizeMessage synchmsg = (SynchronizeMessage)message;
        Logger.loggit(0, String.format("Synchronize %s in %s", synchmsg.getProgram(), this.session.getName()));
        if (synchmsg.getProtsyms().size() == 1 && (prot = (SynchronizeMessage.SynchProtsym)synchmsg.getProtsyms().get(0)).isExact()) {
            file = this.session.refreshFile(synchmsg.getProgram(), prot.getDSN(), true, false, false, prot.getDate(), prot.getTime(), "CICSQueueBreakpoints");
        }
    }
}

