/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.tools.ITException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BreakpointMarker {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private IMarker marker = null;
    private final ArrayList<Long> BreakpointIDs = new ArrayList(1);
    private boolean valid = true;
    private String errorText = null;

    private BreakpointMarker() {
    }

    public BreakpointMarker(IMarker marker) throws ITException {
        try {
            if (!marker.isSubtypeOf("com.ca.intertest.breakpoint") && !marker.isSubtypeOf("com.ca.intertest.monitor")) {
                Logger.loggit(0, marker.getType());
                throw new ITException(Messages.BreakpointMarker_2);
            }
            this.marker = marker;
        }
        catch (CoreException e) {
            throw new ITException((Throwable)e);
        }
    }

    public synchronized long getBreakpointID() {
        return this.BreakpointIDs.size() == 0 ? 0L : this.BreakpointIDs.get(0);
    }

    public synchronized Long[] getBreakpointIDs() {
        return this.BreakpointIDs.toArray(new Long[this.BreakpointIDs.size()]);
    }

    public int getBreakpointIDSize() {
        return this.BreakpointIDs.size();
    }

    public synchronized void setBreakpointID(long breakpointID) {
        if (breakpointID == 0L) {
            this.BreakpointIDs.clear();
        } else {
            this.BreakpointIDs.add(breakpointID);
        }
    }

    public void delete() throws CoreException {
        this.marker.delete();
    }

    public boolean equals(Object object) {
        if (this.marker == object) {
            return true;
        }
        if (this.marker == null || object == null) {
            return false;
        }
        return this.marker.equals(object);
    }

    public boolean exists() {
        return this.marker.exists();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == BreakpointMarker.class) {
            return this;
        }
        return this.marker.getAdapter(adapter);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        return this.marker.getAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        return this.marker.getAttribute(attributeName, defaultValue);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return this.marker.getAttribute(attributeName, defaultValue);
    }

    public Object getAttribute(String attributeName) throws CoreException {
        return this.marker.getAttribute(attributeName);
    }

    public Map<?, ?> getAttributes() throws CoreException {
        return this.marker.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        return this.marker.getAttributes(attributeNames);
    }

    public long getCreationTime() throws CoreException {
        return this.marker.getCreationTime();
    }

    public long getId() {
        return this.marker.getId();
    }

    public IResource getResource() {
        return this.marker.getResource();
    }

    public String getType() throws CoreException {
        return this.marker.getType();
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        return this.marker.isSubtypeOf(superType);
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.marker.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.marker.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        this.marker.setAttribute(attributeName, value);
    }

    public void setAttributes(Map attributes) throws CoreException {
        this.marker.setAttributes(attributes);
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        this.marker.setAttributes(attributeNames, values);
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (valid) {
            this.setErrorText(null);
        }
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }
}

