/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.ITException;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;

public class Snapshot
implements Serializable {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final long serialVersionUID = -1031187270264392656L;
    protected SnapshotType snapshottype;
    protected FileType filetype = null;
    protected long ID = 0L;
    protected ArrayList<Snapshot> children = new ArrayList();
    protected String name = "";
    protected static final String EMPTY = "";
    protected Snapshot parent;

    private Snapshot() {
    }

    public Snapshot(IDebug debugitem) throws ITException {
        this(debugitem, null);
    }

    public Snapshot(IDebug debugitem, String type) throws ITException {
        this();
        if (debugitem instanceof debugSession) {
            this.snapshottype = SnapshotType.SESSION;
            this.filetype = null;
        } else {
            if (!((debugFile)debugitem).isMonitor()) {
                throw new ITException(Messages.Snapshot_1);
            }
            this.snapshottype = SnapshotType.FILE;
            this.filetype = ((debugFile)debugitem).getFiletype();
        }
        this.name = debugitem.getName();
        Object[] objectArray = debugitem.getBreakpointmarkers();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointMarker item = objectArray[n2];
            try {
                if (type == null || type.equals(item.getType())) {
                    Long[] longArray = item.getBreakpointIDs();
                    int n3 = longArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Long id = longArray[n4];
                        Snapshot child = new Snapshot(item);
                        child.setParent(this);
                        child.setID(id);
                        this.children.add(child);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            catch (Exception exception) {}
            ++n2;
        }
        objectArray = debugitem.getChildren();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IDebug) {
                try {
                    Snapshot child = new Snapshot((IDebug)object, type);
                    child.setParent(this);
                    this.children.add(child);
                }
                catch (ITException iTException) {}
            }
            ++n2;
        }
        if (this.children.size() == 0) {
            throw new ITException(Messages.Snapshot_2);
        }
    }

    protected Snapshot(BreakpointMarker item) throws Exception {
        this.ID = item.getBreakpointID();
        if (this.ID == 0L) {
            throw new ITException(Messages.Snapshot_3);
        }
        this.name = item.getType();
        this.snapshottype = SnapshotType.SETTING;
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long id) {
        this.ID = id;
    }

    public ArrayList<Snapshot> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<Snapshot> children) {
        this.children = children;
    }

    public SnapshotType getSnapshottype() {
        return this.snapshottype;
    }

    public FileType getFiletype() {
        return this.filetype;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void addChild(Snapshot child) {
        this.children.add(child);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(String.valueOf(this.snapshottype.toString()) + ":" + this.name);
        if (this.ID != 0L) {
            string.append(" ID:");
            string.append(this.ID);
        }
        for (Snapshot item : this.children) {
            string.append("[" + item.toString() + "]");
        }
        return string.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.children.size() != this.children.size()) {
            return false;
        }
        if (other.snapshottype != this.snapshottype) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.ID != other.ID) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            if (!this.children.get(i).equals(other.children.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Snapshot getParent() {
        return this.parent;
    }

    protected void setParent(Snapshot parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public static enum SnapshotType {
        SESSION,
        FILE,
        SETTING;

    }
}

