/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.Logger;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.XMLFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ResourceProperty {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private IResource resource;
    private ScopedPreferenceStore store;
    private IMarker marker = null;
    private HashMap<String, String> attributes = new HashMap();
    private static final ArrayList<String> reserved = new ArrayList();
    private boolean changed = false;
    private final ListenerList propertyChangeListeners = new ListenerList();

    static {
        String[] stringArray = new String[]{"monitor_pgm"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            reserved.add(item);
            ++n2;
        }
    }

    protected ResourceProperty(IResource resource) {
        this.resource = resource;
        this.store = new ScopedPreferenceStore((IScopeContext)new DefaultScope(), "com.ca.intertest");
        this.load();
    }

    private void load() {
        this.save();
        IMarker[] markers = null;
        HashMap<Object, Object> map = new HashMap(0);
        try {
            if (this.resource.getType() == 4) {
                markers = this.resource.findMarkers("com.ca.intertest.project", false, 0);
            } else if (this.resource.getType() == 1) {
                markers = this.resource.findMarkers("com.ca.intertest.file", false, 0);
                map = this.buildMarkers((IFile)this.resource);
            } else {
                return;
            }
            if (markers != null && markers.length > 0) {
                this.marker = markers[0];
                Map attrs = this.marker.getAttributes();
                if (attrs != null) {
                    for (Map.Entry entry : attrs.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        this.putValue(key, value);
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (reserved.contains(key)) continue;
            String value = (String)entry.getValue();
            this.putValue(key, value);
        }
    }

    private HashMap<String, String> buildMarkers(IFile file) {
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file.getLocation().toFile(), 1);
            ZipEntry zipEntry = zipFile.getEntry("metadata");
            if (zipEntry != null) {
                is = zipFile.getInputStream(zipEntry);
            }
        }
        catch (IOException iOException) {}
        HashMap<String, String> attribs = null;
        if (is != null) {
            try {
                XMLFile xml = new XMLFile(is);
                Element member = xml.getFirstMember();
                NamedNodeMap attrs = member.getAttributes();
                attribs = new HashMap(attrs.getLength());
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    String key = attr.getName();
                    if (!reserved.contains(key)) {
                        String value = attr.getValue().trim();
                        attribs.put(attr.getName(), value);
                    }
                    ++i;
                }
            }
            catch (ITException iTException) {
                attribs = new HashMap(0);
            }
        } else {
            attribs = new HashMap<String, String>(0);
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return attribs;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public boolean contains(String name) {
        String result = this.getString(name);
        return result.length() > 0;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this.resource, name, oldValue, newValue);
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    public boolean getBoolean(String name) {
        String result = this.getString(name);
        return result.length() > 0 ? Boolean.parseBoolean(result) : this.getDefaultBoolean(name);
    }

    private boolean getDefaultBoolean(String name) {
        return this.store.getDefaultBoolean(name);
    }

    private double getDefaultDouble(String name) {
        return this.store.getDefaultDouble(name);
    }

    private float getDefaultFloat(String name) {
        return this.store.getDefaultFloat(name);
    }

    private int getDefaultInt(String name) {
        return this.store.getDefaultInt(name);
    }

    private long getDefaultLong(String name) {
        return this.store.getDefaultLong(name);
    }

    private String getDefaultString(String name) {
        return this.store.getDefaultString(name);
    }

    public double getDouble(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Double.parseDouble(result) : this.getDefaultDouble(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public float getFloat(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Float.parseFloat(result) : this.getDefaultFloat(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public int getHex(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Integer.parseInt(result, 16) : this.getDefaultInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getInt(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Integer.parseInt(result) : this.getDefaultInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Long.parseLong(result) : this.getDefaultLong(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String getString(String name) {
        String result = null;
        result = this.attributes.get(name);
        return result == null ? this.getDefaultString(name) : result;
    }

    public boolean isDefault(String name) {
        String defaultstr = this.getDefaultString(name);
        try {
            String result = this.resource.getPersistentProperty(new QualifiedName("com.ca.intertest", name));
            return result.equals(defaultstr);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean needsSaving() {
        return this.changed;
    }

    protected void putValue(String name, String value) {
        String oldValue = this.attributes.put(name, value);
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        this.changed = true;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public void setToDefault(String name) {
        this.putValue(name, null);
    }

    public void setValue(String name, double value) {
        this.putValue(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        this.putValue(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        this.putValue(name, Integer.toString(value));
    }

    public void setHexValue(String name, int value) {
        this.putValue(name, Integer.toString(value, 16));
    }

    public void setValue(String name, long value) {
        this.putValue(name, Long.toString(value));
    }

    public void setValue(String name, String value) {
        this.putValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.putValue(name, Boolean.toString(value));
    }

    public void save() {
        if (this.changed && this.resource.exists() && !this.resource.getWorkspace().isTreeLocked()) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (ResourceProperty.this.marker == null || !ResourceProperty.this.marker.exists()) {
                        if (ResourceProperty.this.resource.getType() == 4) {
                            ResourceProperty.this.marker = ResourceProperty.this.resource.createMarker("com.ca.intertest.project");
                        } else if (ResourceProperty.this.resource.getType() == 1) {
                            ResourceProperty.this.marker = ResourceProperty.this.resource.createMarker("com.ca.intertest.file");
                        }
                    }
                    if (ResourceProperty.this.marker != null) {
                        ResourceProperty.this.marker.setAttributes((Map)ResourceProperty.this.attributes);
                        if (ResourceProperty.this.resource.getType() == 1 && ResourceProperty.this.getBoolean("com.ca.intertest")) {
                            ResourceProperty.this.resource.setPersistentProperty(new QualifiedName("com.ca.intertest", "com.ca.intertest"), "true");
                        }
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, (ISchedulingRule)this.resource.getProject(), 1, null);
                this.changed = false;
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.save();
        super.finalize();
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public IResource getResource() {
        return this.resource;
    }

    public static ResourceProperty getStore(IResource resource) {
        IDebug item = Debug.getInstance().getResource(resource);
        ResourceProperty store = null;
        if (item != null) {
            store = item.getStore();
        }
        if (store == null) {
            return new ResourceProperty(resource);
        }
        return store;
    }

    public void reLoad() {
        this.load();
    }

    public String toString() {
        if (this.resource != null) {
            return this.resource.toString();
        }
        return super.toString();
    }
}

