/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Variable;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import org.w3c.dom.Element;

public class PLIVariable
extends Variable {
    private static final int zeroChar = 0;
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    public PLIVariable(Element element) throws ITException {
        super(element);
        this.setDatatype();
    }

    @Override
    public boolean canEditDisplay() {
        if (this.hasChildren()) {
            return false;
        }
        switch (this.storagetype) {
            default: {
                return false;
            }
            case BIN: {
                return this.datatype != Variable.DataType.FLOAT;
            }
            case PACK: {
                return this.datatype != Variable.DataType.FLOAT;
            }
            case CHAR: 
            case DISPLAY: 
            case DISPLAY_SIGNED_LEFT: 
            case DISPLAY_SIGNED_SEPARATE: 
            case DISPLAY_SIGNED_SEPARATE_LEFT: 
        }
        return true;
    }

    @Override
    public boolean canEditHex() {
        return true;
    }

    @Override
    public String getDisplayValue() throws Exception {
        if (this.hasChildren()) {
            return GROUP_LEVEL;
        }
        if (!this.canEditDisplay()) {
            return NOT_DISPLAYABLE;
        }
        if (this.backingdata == null) {
            return NOT_AVAILABLE;
        }
        return this.getValue(this.getData());
    }

    @Override
    protected void setDatatype() {
        int pvdes;
        boolean isFloat = false;
        String sPvdes = this.getAttribute("gt_pvdes");
        if (sPvdes.length() > 0 && ((pvdes = Integer.parseInt(sPvdes, 16)) & 2) != 0) {
            isFloat = true;
        }
        int sign = (Integer)Attribute.getValue("gt_sign", this);
        Variable.DataType numeric = (sign &= 8) == 0 ? Variable.DataType.UNSIGNED : Variable.DataType.SIGNED;
        int pvdtp = (Integer)Attribute.getValue("gt_pvdtp", this);
        switch (pvdtp) {
            case 4: {
                this.datatype = isFloat ? Variable.DataType.FLOAT : numeric;
                this.storagetype = Variable.StorageType.BIN;
                break;
            }
            case 8: {
                this.datatype = isFloat ? Variable.DataType.FLOAT : numeric;
                this.storagetype = Variable.StorageType.PACK;
                break;
            }
            case 16: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            case 64: 
            case 80: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            case 32: {
                this.datatype = Variable.DataType.BIT;
                this.storagetype = Variable.StorageType.HEX;
            }
            default: {
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
            }
        }
    }

    @Override
    public int getSigFigRight() {
        int dptyp = (Integer)Attribute.getValue("gt_dptyp", this);
        if (dptyp == 5) {
            return 0;
        }
        int iScale = 0;
        String pic = (String)Attribute.getValue("gt_pic", this);
        if (pic != null && pic.length() > 0) {
            return this.parsePic(pic);
        }
        String scale = this.getAttribute("gt_scale");
        if (scale.length() > 0) {
            iScale = Integer.parseInt(scale, 16);
        }
        if (iScale > 127) {
            iScale -= 256;
        }
        return iScale;
    }

    public int parsePic(String pic) {
        String sep = "V";
        int ptr = pic.indexOf(sep);
        if (ptr == -1) {
            sep = ".";
            ptr = pic.indexOf(sep);
            sep = "[.]";
        }
        if (ptr > -1) {
            String[] tokens = pic.split(sep);
            ptr = tokens[1].indexOf("(");
            if (ptr > -1) {
                int ptr2 = tokens[1].indexOf(")");
                if (ptr2 > -1 && ptr2 > ptr) {
                    int numberofdigits = Integer.valueOf(tokens[1].substring(ptr + 1, ptr2));
                    return tokens[1].length() + numberofdigits - 3 - ptr2 + ptr + 1;
                }
            } else {
                return tokens[1].length();
            }
        }
        return 0;
    }

    @Override
    public String varyCheck(String value, boolean isTrim) {
        int pvdes;
        String sPvdes;
        String newValue = value;
        Integer pvdtp = (Integer)Attribute.getValue("gt_pvdtp", this);
        if (pvdtp == 16 && (sPvdes = this.getAttribute("gt_pvdes")).length() > 0 && ((pvdes = Integer.parseInt(sPvdes, 16)) & 1) != 0) {
            this.isVarying = true;
            newValue = isTrim ? value.substring(2, value.length()) : this.getVarString(value);
        }
        return newValue;
    }

    public String getVarString(String value) {
        int i;
        AbstractStringBuilder sb;
        byte[] sBytes = null;
        byte[] bytes2 = new byte[4];
        String hexStr = "";
        String hexNum = "";
        int len = value.length();
        int varLth = 0;
        if (len > 0) {
            byte[] bytes = new byte[len];
            sb = new StringBuilder(len);
            i = value.length() - 1;
            while (i > -1) {
                char ch1 = value.charAt(i);
                if (ch1 != '\u0000' && ch1 != ' ' && ch1 != HexUtil.dot && varLth == 0) {
                    varLth = i + 1;
                    i = -1;
                }
                --i;
            }
            ((StringBuilder)sb).append(value.substring(0, varLth));
            hexStr = ((StringBuilder)sb).toString();
            try {
                HexUtil.StringtoBytes((String)hexStr, (byte[])bytes);
                hexStr = HexUtil.toHex((byte[])bytes, (int)0);
            }
            catch (Exception exception) {
                hexStr = "";
            }
        }
        try {
            HexUtil.NumbertoByte((String)String.valueOf(varLth), (byte[])bytes2);
            hexNum = HexUtil.toHex((byte[])bytes2).substring(4, 8);
        }
        catch (Exception exception) {}
        hexStr = String.valueOf(hexNum) + hexStr;
        sBytes = HexUtil.HextoBytes((String)hexStr);
        String str = HexUtil.toString((byte[])sBytes, (boolean)true);
        if ((varLth += 2) > 0 && varLth < (len += 2)) {
            sb = new StringBuffer(len);
            i = 0;
            while (i < len) {
                if (i < varLth) {
                    ((StringBuffer)sb).append(str.substring(i, i + 1));
                } else {
                    ((StringBuffer)sb).append(0);
                }
                ++i;
            }
            str = ((StringBuffer)sb).toString();
        }
        return str;
    }
}

