/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Logger {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static ILog log = IntertestPlugin.getDefault().getLog();
    private static Object waiting = new Object();
    private static boolean logging;
    private static boolean logpackets;
    private static boolean displaypackets;

    static {
        IntertestPlugin.getConfigurationPreferences().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("logging")) {
                    Logger.setFlags();
                }
            }
        });
        Logger.setFlags();
    }

    private static void setFlags() {
        logpackets = logging = IntertestPlugin.isTracing() ? true : IntertestPlugin.getConfigurationPreferences().getBoolean("logging");
        displaypackets = logging ? Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/debug/displaypackets")) : false;
    }

    private Logger() {
    }

    public static boolean isLogging() {
        return logging;
    }

    public static void loggit(Throwable e) {
        if (e == null) {
            return;
        }
        Logger.loggit((IStatus)new Status(4, "com.ca.intertest", 0, HexUtil.getErrorText((Throwable)e), e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loggit(IStatus status) {
        if (status == null) {
            return;
        }
        if (logging) {
            IntertestPlugin.startErrorLog();
        }
        Object object = waiting;
        synchronized (object) {
            log.log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loggit(int errorlevel, String message) {
        if (!logging && errorlevel == 0) {
            return;
        }
        if (errorlevel >= 8) {
            IntertestPlugin.startErrorLog();
        }
        Object object = waiting;
        synchronized (object) {
            log.log((IStatus)new Status(Logger.setStatus(errorlevel), "com.ca.intertest", errorlevel, message, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loggit(int errorlevel, String message, Throwable e) {
        if (!logging && errorlevel == 0) {
            return;
        }
        if (errorlevel >= 8) {
            IntertestPlugin.startErrorLog();
        }
        if (e == null) {
            Logger.loggit(errorlevel, message);
        } else {
            Object object = waiting;
            synchronized (object) {
                log.log((IStatus)new Status(Logger.setStatus(errorlevel), "com.ca.intertest", errorlevel, message, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loggit(int errorlevel, String[] messages) {
        if (!logging && errorlevel == 0) {
            return;
        }
        if (errorlevel >= 8) {
            IntertestPlugin.startErrorLog();
        }
        int length = 0;
        StringBuilder text = new StringBuilder("");
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            text.append(HexUtil.rightTrim((String)line));
            length = text.length();
            text.append(IConstants.LINEFEED);
            ++n2;
        }
        text.setLength(length);
        Object object = waiting;
        synchronized (object) {
            log.log((IStatus)new Status(Logger.setStatus(errorlevel), "com.ca.intertest", errorlevel, text.toString(), null));
        }
    }

    public static void logPacket(Object object, Class<?> bufferClass, Throwable throwable, String prefix) {
        if (!logpackets) {
            return;
        }
        String string = prefix == null ? "" : (prefix = prefix.endsWith(" ") ? prefix : String.valueOf(prefix) + " ");
        if (DSECT.class.isAssignableFrom(bufferClass)) {
            byte[] buffer = (byte[])object;
            String msg = String.format(Messages.Logger_6, bufferClass.getSimpleName(), buffer.length);
            Logger.loggit(0, HexUtil.toHexDump((byte[])buffer, (String)(String.valueOf(prefix) + msg)), Logger.checkThrowable(throwable));
        } else if (DebugTalker.class.isAssignableFrom(bufferClass)) {
            Logger.loggit(0, String.valueOf(prefix) + object.toString(), Logger.checkThrowable(throwable));
        } else {
            String message = String.format(Messages.Logger_7, bufferClass.getSimpleName());
            Logger.loggit(0, String.valueOf(prefix) + message);
        }
    }

    public static void DisplayPacket(DSECT dsect, Throwable throwable) {
        if (!displaypackets) {
            return;
        }
        StringBuilder tostring = new StringBuilder();
        tostring.append(String.format(Messages.Logger_12, dsect.getClass().getSimpleName(), dsect.size()));
        DebugMessage[] debugMessageArray = dsect.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            tostring.append(IConstants.LINEFEED);
            tostring.append(message.toString());
            ++n2;
        }
        Logger.loggit(0, tostring.toString(), Logger.checkThrowable(throwable));
    }

    private static Throwable checkThrowable(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable();
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            StackTraceElement[] newstackTrace = new StackTraceElement[stackTrace.length - 1];
            System.arraycopy(stackTrace, 1, newstackTrace, 0, newstackTrace.length);
            throwable.setStackTrace(newstackTrace);
        }
        return throwable;
    }

    private static int setStatus(int errorlevel) {
        if (errorlevel == 0) {
            return 1;
        }
        if (errorlevel < 5) {
            return 2;
        }
        IntertestPlugin.startErrorLog();
        return 4;
    }

    public static Logger getLogger(String name) {
        return null;
    }
}

