/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.parseASM;
import com.ca.intertest.tools.parseCOBOL;
import com.ca.intertest.tools.parsePLI;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.w3c.dom.Element;

public class DummyListing {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String DUMMY_LISTING_TEXT = String.valueOf(Messages.DummyListing_0) + IConstants.LINEFEED + Messages.DummyListing_1 + IConstants.LINEFEED + Messages.DummyListing_2;
    private Exception interrupt = null;
    private FileOutputStream dest;
    private ZipOutputStream zipout;
    private File zipfile;
    final IFile filelisting;
    private ResourceProperty store = null;
    private Member member;
    private String listingtext;
    private static final String[] delete_attrs = new String[]{"firststatement", "gt_m_cty", "gt_m_flg", "gt_m_jul", "gt_m_opt", "gt_m_re_", "gt_m_tim", "gt_m_xa", "laststatement", "monitor_pgm", "records", "version"};
    private static final int zipMethod = 0;

    public DummyListing(Member memberinfo, debugSession session) {
        memberinfo.setDate(61001);
        memberinfo.setTime(0);
        memberinfo.setTimestamp(HexUtil.TimeStamp((int)memberinfo.getDate(), (int)memberinfo.getTime()));
        memberinfo.setAttribute("time", HexUtil.TimeStampString((int)memberinfo.getDate(), (int)memberinfo.getTime()));
        memberinfo.setAttribute("gt_m_jul", Integer.toString(memberinfo.getDate()));
        memberinfo.setAttribute("gt_m_tim", Integer.toString(memberinfo.getTime()));
        this.member = new Member();
        for (Map.Entry<String, String> item : memberinfo.getAttributes().entrySet()) {
            this.member.setAttribute(item.getKey(), item.getValue());
        }
        debugFile debugfile = session.getFile(memberinfo.getName());
        if (debugfile == null) {
            this.filelisting = ((IProject)session.getResource()).getFile(String.valueOf(memberinfo.getName()) + ".intertest");
        } else {
            if (this.store == null) {
                this.store = debugfile.getStore();
            }
            for (Map.Entry<String, String> item : this.store.getAttributes().entrySet()) {
                this.member.setAttribute(item.getKey(), item.getValue());
            }
            this.filelisting = (IFile)debugfile.getResource();
        }
        String[] stringArray = delete_attrs;
        int n = delete_attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            this.member.setAttribute(attr, null);
            ++n2;
        }
        this.member.setName(memberinfo.getName());
        this.member.setDate(61001);
        this.member.setTime(0);
        this.member.setTimestamp(HexUtil.TimeStamp((int)memberinfo.getDate(), (int)memberinfo.getTime()));
        this.member.setAttribute("time", HexUtil.TimeStampString((int)this.member.getDate(), (int)this.member.getTime()));
        this.member.setAttribute("gt_m_jul", Integer.toString(this.member.getDate()));
        this.member.setAttribute("gt_m_tim", Integer.toString(this.member.getTime()));
        this.setListingtext(null);
    }

    public void build() {
        parseCOBOL parser;
        XMLFile source = new XMLFile();
        Element cmd = source.setCommand("getfile");
        cmd.setAttribute("dsn", "Unknown");
        cmd.setAttribute("name", this.member.getName());
        for (Map.Entry<String, String> item : this.member.getAttributes().entrySet()) {
            cmd.setAttribute(item.getKey(), item.getValue());
        }
        Element xmlmember = this.member.xmlMember(source);
        switch ((Integer)Attribute.getValue((String)"gt_m_lang", (Element)xmlmember)) {
            case 32: {
                parser = new parseCOBOL(source, xmlmember);
                break;
            }
            case 128: {
                parser = new parsePLI(source, xmlmember);
                break;
            }
            case 16: {
                parser = new parseASM(source, xmlmember);
                break;
            }
            default: {
                parser = new parseASM(source, xmlmember);
                xmlmember.setAttribute("gt_m_lang", Integer.toHexString(16));
            }
        }
        try {
            this.loadListingFile(source, this.member.getDsn(), 0, this.filelisting);
        }
        catch (InterruptedException e) {
            this.interrupt = e;
            return;
        }
        if (this.store == null) {
            this.store = ResourceProperty.getStore((IResource)this.filelisting);
        }
        xmlmember.setAttribute("com.ca.intertest", "true");
        parser.populateXML();
        String[] stringArray = delete_attrs;
        int n = delete_attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            this.store.setToDefault(attr);
            ++n2;
        }
        for (Map.Entry<String, String> item : this.member.getAttributes().entrySet()) {
            this.store.setValue(item.getKey(), item.getValue());
        }
        ZipEntry entry = new ZipEntry("metadata");
        try {
            this.zipout.putNextEntry(entry);
            source.toFile((Writer)new BufferedWriter(new OutputStreamWriter(this.zipout)));
            this.zipout.closeEntry();
            this.zipout.close();
            this.dest.close();
            final FileInputStream zip = new FileInputStream(this.zipfile);
            if (this.filelisting.exists()) {
                ResourceAttributes attrs = this.filelisting.getResourceAttributes();
                if (attrs != null && attrs.isReadOnly()) {
                    attrs.setReadOnly(false);
                    this.filelisting.setResourceAttributes(attrs);
                }
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        DummyListing.this.filelisting.setContents(zip, true, true, null);
                    }
                };
                ResourcesPlugin.getWorkspace().run(r, (ISchedulingRule)this.filelisting.getProject(), 1, null);
            } else {
                this.filelisting.create((InputStream)zip, true, null);
            }
            this.store.save();
            this.filelisting.refreshLocal(0, null);
        }
        catch (CoreException e) {
            Logger.loggit(e);
            this.interrupt = e;
            return;
        }
        catch (IOException e) {
            Logger.loggit(e);
            this.interrupt = e;
            return;
        }
        parser.dispose();
        try {
            Debug.getInstance().addDebugSession((IResource)this.filelisting);
        }
        catch (ITException e) {
            Logger.loggit(e);
            this.interrupt = e;
            return;
        }
    }

    private void loadListingFile(XMLFile source, String tempfile, int records, IFile filelisting) throws InterruptedException {
        try {
            this.zipfile = File.createTempFile("CAIT", ".zip");
            this.zipfile.deleteOnExit();
            this.dest = new FileOutputStream(this.zipfile);
            this.zipout = new ZipOutputStream(new BufferedOutputStream(this.dest));
            this.zipout.setMethod(0);
            this.dest = new FileOutputStream(this.zipfile);
            this.zipout = new ZipOutputStream(new BufferedOutputStream(this.dest));
            String userid = System.getenv("USERNAME");
            userid = userid == null ? "" : userid.toUpperCase();
            this.zipout.setComment(String.valueOf(Messages.DummyListing_22) + userid);
            ZipEntry entry = new ZipEntry("listing");
            this.zipout.putNextEntry(entry);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.zipout));
            out.write(this.listingtext);
            out.newLine();
            out.flush();
            this.zipout.closeEntry();
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.interrupt = e;
        }
    }

    public Exception getInterrupt() {
        return this.interrupt;
    }

    public int getResult() {
        if (this.interrupt != null) {
            return -1;
        }
        return 2;
    }

    public void setListingtext(String listingtext) {
        this.listingtext = String.format(DUMMY_LISTING_TEXT, "program", this.member.getName());
        if (listingtext != null && listingtext.length() > 0) {
            this.listingtext = String.valueOf(this.listingtext) + IConstants.LINEFEED + IConstants.LINEFEED + listingtext;
        }
    }
}

