/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.part.ResourceTransfer;

public class DragDebugFile
extends DragSourceAdapter {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private StructuredViewer viewer;

    public DragDebugFile(StructuredViewer viewer) {
        this();
        this.viewer = viewer;
    }

    private DragDebugFile() {
    }

    public void dragFinished(DragSourceEvent event) {
        super.dragFinished(event);
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<IResource> list = new ArrayList<IResource>(selection.size());
            for (Object item : selection.toList()) {
                if (item instanceof IT_TreeItem) {
                    item = ((IT_TreeItem)item).getObj();
                }
                if (item instanceof debugFile) {
                    item = ((debugFile)item).getResource();
                }
                if (!(item instanceof IFile)) continue;
                list.add((IResource)item);
            }
            event.data = list.toArray(new IResource[list.size()]);
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            event.doit = false;
        } else {
            debugSession session = null;
            for (Object obj : selection.toList()) {
                if (obj instanceof IT_TreeItem) {
                    obj = ((IT_TreeItem)obj).getObj();
                }
                if (obj instanceof debugFile) {
                    debugFile file = (debugFile)obj;
                    if (session == null) {
                        session = file.getSession();
                    } else if (!session.equals(file.getSession())) {
                        event.doit = false;
                        break;
                    }
                    if (event.doit && session.isBatch() && session.isDebugging()) {
                        event.doit = false;
                        break;
                    }
                    if (!event.doit || !file.isSubModule()) continue;
                    event.doit = false;
                    break;
                }
                event.doit = false;
                break;
            }
        }
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }
}

