/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.nio.ByteBuffer;

public class SchedulingTransferMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected String DSName = "";
    protected String member = "";
    protected String dstype = "P";
    protected byte hexflag = 1;

    public SchedulingTransferMessage() {
    }

    public SchedulingTransferMessage(short submessageID) throws ITException {
        this();
        this.setSubmessageID(submessageID);
    }

    protected void buildMessage() throws Exception {
        this.buffer.put(this.dstype.getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.DSName, 44).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.member, 8).getBytes("IBM1047"));
        this.buffer.put(this.hexflag);
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] byte1 = new byte[1];
        this.buffer.get(byte1);
        this.dstype = new String(byte1, "IBM1047");
        byte[] dsn = new byte[44];
        this.buffer.get(dsn);
        this.DSName = HexUtil.rightTrim(new String(dsn, "IBM1047"));
        byte[] mem = new byte[8];
        this.buffer.get(mem);
        this.member = HexUtil.rightTrim(new String(mem, "IBM1047"));
        this.hexflag = this.buffer.get();
    }

    public String getDstype() {
        return this.dstype;
    }

    public void setDstype(String sDstype) {
        this.dstype = (sDstype + " ").substring(0, 1);
    }

    public String getDSName() {
        if (this.DSName != null) {
            return this.DSName.trim();
        }
        return null;
    }

    public void setDSName(String name) {
        this.DSName = String.format("%-44s", name);
    }

    public String getMember() {
        if (this.member != null) {
            return this.member.trim();
        }
        return null;
    }

    public void setMember(String mem) {
        this.member = String.format("%-8s", mem);
    }

    protected short _defaultID() {
        return 45;
    }

    public void setSubmessageID(short submessageID) throws ITException {
        super.setSubmessageID(submessageID);
    }

    protected int _getMessageSize() {
        return 500;
    }

    protected String _toString() {
        return null;
    }
}

