/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCountsMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected HashMap<Integer, Integer> countsTable;
    protected int maxCount = 0;
    protected int resultCode = 0;

    public GetCountsMessage() {
        super(true);
    }

    @Override
    protected short _defaultID() {
        return 38;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.resultCode = newbuffer.getInt();
        try {
            this.getProgram(newbuffer);
            this.getAvailable(newbuffer);
            byte[] buf8 = new byte[8];
            int qtyEntries = newbuffer.getInt();
            this.countsTable = new HashMap(qtyEntries);
            ByteBuffer item = ByteBuffer.wrap(buf8);
            for (int i = 0; i < qtyEntries; ++i) {
                buf8[0] = 0;
                newbuffer.get(buf8, 1, 7);
                ((Buffer)item).position(0);
                Integer statement = item.getInt();
                Integer count = item.getInt();
                if (count <= 0) continue;
                this.countsTable.put(statement, count);
                if (count <= this.maxCount) continue;
                this.maxCount = count;
            }
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    @Override
    protected int _getMessageSize() {
        return 8 + 8 * this.countsTable.size();
    }

    @Override
    protected String _toString() {
        return null;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.putProgram());
        this.buffer.putInt(this.resultCode);
        this.buffer.putInt(this.countsTable.size());
        byte[] itembytes = new byte[8];
        ByteBuffer itembuffer = ByteBuffer.wrap(itembytes);
        for (Map.Entry<Integer, Integer> item : this.countsTable.entrySet()) {
            ((Buffer)itembuffer).position(0);
            itembuffer.putInt(item.getKey());
            itembuffer.putInt(item.getValue());
            this.buffer.put(itembytes, 1, 7);
        }
    }

    public HashMap<Integer, Integer> getCountsTable() {
        if (this.countsTable == null) {
            this.countsTable = new HashMap(0);
        }
        return this.countsTable;
    }

    public void setCountsTable(HashMap<Integer, Integer> countsTable) {
        this.countsTable = countsTable;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }
}

