/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class EndTaskMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final short BATCH = 0;
    public static final short CICS = 1;
    public static final short CICS_SERVICE = 2;
    protected String tranid = "";
    protected int returncode = 0;
    protected int userabend = 0;
    protected int systemabend = 0;
    protected int sessionID;
    protected String AbendMessage;

    protected short _defaultID() {
        return 4;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            if (this.submessageID == 1) {
                byte[] buf = new byte[4];
                this.buffer.get(buf);
                this.tranid = HexUtil.rightTrim(new String(buf, "IBM1047"));
            } else {
                this.returncode = this.buffer.getInt();
            }
            this.userabend = this.buffer.getInt();
            this.systemabend = this.buffer.getInt();
            this.sessionID = this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            Logger.loggit(e);
            throw new ITException("Invalid content for EndTask message", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITException(e.getCause());
        }
    }

    protected void buildMessage() throws Exception {
        if (this.submessageID == 1) {
            this.buffer.put(HexUtil.spaceFill(this.tranid, 4).getBytes("IBM1047"));
        } else {
            this.buffer.putInt(this.returncode);
        }
        this.buffer.putInt(this.userabend);
        this.buffer.putInt(this.systemabend);
        this.buffer.putInt(this.sessionID);
    }

    public int getReturncode() {
        return this.returncode;
    }

    public void setReturncode(int returncode) {
        this.returncode = returncode;
    }

    public int getSystemabend() {
        return this.systemabend;
    }

    public void setSystemabend(int systemabend) {
        this.systemabend = systemabend;
    }

    public String getTranid() {
        return this.tranid;
    }

    public void setTranid(String tranid) {
        this.tranid = tranid;
    }

    public int getUserabend() {
        return this.userabend;
    }

    public void setUserabend(int userabend) {
        this.userabend = userabend;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    protected int _getMessageSize() {
        return 16;
    }

    protected String _toString() {
        return null;
    }

    public String getAbendMessage() {
        return this.AbendMessage == null ? "" : this.AbendMessage;
    }

    public void setAbendMessage(String abendMessage) {
        this.AbendMessage = abendMessage;
    }
}

